/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xslt;

import com.japisoft.editix.ui.xslt.CurrentHighlighter;
import com.japisoft.editix.ui.xslt.Factory;
import com.japisoft.editix.ui.xslt.XSLTBookmarkContext;
import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.editix.ui.xslt.XSLTFilesListener;
import com.japisoft.editix.ui.xslt.XSLTTemplates;
import com.japisoft.fastparser.ParseException;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.xmlpad.DocumentStateListener;
import com.japisoft.xmlpad.IView;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class XSLTFiles
extends JTabbedPane
implements ChangeListener,
DocumentStateListener,
MouseListener,
ActionListener {
    private Factory factory;
    private XMLContainer mainContainer;
    private XSLTFilesListener listener;
    private HashMap sharedProperties = null;
    private boolean initListeners = false;
    private Object currentLineMarker = null;
    private Map resolvedURI = null;
    private boolean initTemplatesTab = false;
    private XSLTTemplates templates = null;

    public XSLTFiles(Factory factory, XSLTFilesListener xSLTFilesListener) {
        this.factory = factory;
        this.listener = xSLTFilesListener;
        this.initUI();
    }

    private XMLContainer buildNewContainer(boolean bl) {
        Object var2_2 = null;
        XMLContainer xMLContainer = this.factory.buildNewContainer(null);
        if (this.sharedProperties == null) {
            this.sharedProperties = new HashMap();
        }
        xMLContainer.resetProperties(this.sharedProperties);
        xMLContainer.setTreePopupAvailable(false);
        xMLContainer.getUIAccessibility().setTreeToolBarAvailable(false);
        xMLContainer.setProperty("prefAPosEntity", Boolean.FALSE);
        if (bl) {
            xMLContainer.getMainContainer().setBookmarkContext(new XSLTBookmarkContext());
        }
        return xMLContainer;
    }

    private void initUI() {
        this.mainContainer = this.buildNewContainer(false);
        this.addTabXMLContainer("Main", this.mainContainer);
        this.initListeners();
    }

    private void initListeners() {
        if (!this.initListeners) {
            for (int i = 0; i < this.getXMLContainerCount(); ++i) {
                this.getXMLContainer(i).addDocumentStateListener(this);
            }
            this.addChangeListener(this);
            this.initListeners = true;
        }
    }

    private void removeListeners() {
        if (this.initListeners) {
            this.initListeners = false;
            this.removeChangeListener(this);
            for (int i = 0; i < this.getXMLContainerCount(); ++i) {
                this.getXMLContainer(i).removeDocumentStateListener(this);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.initListeners();
        this.addMouseListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
        this.removeMouseListener(this);
    }

    public void showCurrentLine(String string, int n) {
        this.cleanCurrentLineMarker();
        if (n >= 0) {
            XMLContainer xMLContainer = this.getContainerForUri(string);
            XMLDocument xMLDocument = xMLContainer.getDocument();
            Element element = xMLDocument.getDefaultRootElement().getElement(n);
            XMLEditor xMLEditor = xMLContainer.getEditor();
            try {
                this.currentLineMarker = xMLEditor.getHighlighter().addHighlight(element.getStartOffset(), element.getEndOffset(), new CurrentHighlighter());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            int n2 = element.getStartOffset();
            xMLEditor.setCaretPositionWithoutNotification(n2);
        }
    }

    private void cleanCurrentLineMarker() {
        if (this.currentLineMarker != null) {
            for (int i = 0; i < this.getXMLContainerCount(); ++i) {
                this.getXMLContainer(i).getEditor().getHighlighter().removeHighlight(this.currentLineMarker);
            }
            this.currentLineMarker = null;
        }
    }

    private XMLContainer getContainerForUri(String string) {
        String string2 = string;
        int n = 0;
        if (string != null) {
            n = string.lastIndexOf("/");
            if (n == -1) {
                n = string.lastIndexOf("\\");
            }
            if (n > -1) {
                string2 = string2.substring(n + 1);
            }
        }
        XMLContainer xMLContainer = this.mainContainer.getMainContainer();
        for (n = 0; n < this.getXMLContainerCount(); ++n) {
            XMLContainer xMLContainer2 = this.getXMLContainer(n);
            String string3 = xMLContainer2.getCurrentDocumentLocation();
            if (string3 == null) continue;
            int n2 = string3.lastIndexOf("/");
            if (n2 == -1) {
                n2 = string3.lastIndexOf("\\");
            }
            if (n2 > -1) {
                string3 = string3.substring(n2 + 1);
            }
            if (!string3.equalsIgnoreCase(string2)) continue;
            this.setSelectedComponent(xMLContainer2.getView());
            xMLContainer = xMLContainer2;
        }
        return xMLContainer;
    }

    public void showXSLTLine(String string, int n) {
        XMLContainer xMLContainer = this.getContainerForUri(string);
        xMLContainer.getEditor().highlightLine(n);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getSelectedComponent() instanceof IView) {
            if (this.listener != null) {
                this.listener.setCurrentContainer(((IView)((Object)this.getSelectedComponent())).getContainer());
            }
        } else if (this.getSelectedComponent() instanceof XSLTTemplates) {
            ((XSLTTemplates)this.getSelectedComponent()).updateContent();
        }
    }

    public int getXMLContainerCount() {
        int n = 0;
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!(this.getComponentAt(i) instanceof IView)) continue;
            ++n;
        }
        return n;
    }

    public XMLContainer getXMLContainer(int n) {
        int n2 = n;
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!(this.getComponentAt(i) instanceof IView)) continue;
            if (n2 == 0) {
                return ((IView)((Object)this.getComponentAt(i))).getContainer();
            }
            --n2;
        }
        return null;
    }

    public SimpleNode getXMLContainerRootNode(int n) {
        XMLContainer xMLContainer = this.getXMLContainer(n);
        if (xMLContainer == null) {
            return null;
        }
        SimpleNode simpleNode = xMLContainer.getRootNode();
        if (simpleNode == null) {
            simpleNode = this.getRoot(xMLContainer);
        }
        return simpleNode;
    }

    private SimpleNode getRoot(XMLContainer xMLContainer) {
        String string = xMLContainer.getText();
        Parser parser = new Parser();
        parser.setContent(string.toCharArray());
        try {
            parser.parse();
            return (SimpleNode)parser.getDocument().getRoot();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void documentModified(XMLContainer xMLContainer) {
        int n = this.indexOfComponent(xMLContainer.getView());
        if (n > -1) {
            String string = this.getTitleAt(n);
            if (string.indexOf("*") == -1) {
                string = string + "*";
            }
            this.setTitleAt(n, string);
            if (xMLContainer != this.mainContainer) {
                this.mainContainer.setModifiedState(true);
            }
        }
    }

    public void resetVisualState(XMLContainer xMLContainer) {
        String string;
        int n = this.indexOfComponent(xMLContainer.getView());
        if (n > -1 && (string = this.getTitleAt(n)).endsWith("*")) {
            this.setTitleAt(n, string.substring(0, string.length() - 1));
        }
    }

    public void newDocument(XMLContainer xMLContainer) {
        SimpleNode simpleNode = this.getRoot(xMLContainer);
        if (simpleNode != null) {
            this.resetIncludeImportTabs(xMLContainer, simpleNode);
        }
        this.removeListeners();
        this.initListeners();
        this.initTemplatesTab();
        xMLContainer.getEditor().setTransferHandler(new XSLTEditor.DropSimpleNodeTransferHandler(xMLContainer.getEditor().getTransferHandler()));
    }

    public void dispose() {
        this.mainContainer.dispose();
        if (this.templates != null) {
            this.templates.dispose();
        }
    }

    public void selectNode(XMLContainer xMLContainer, SimpleNode simpleNode) {
        this.setSelectedComponent(xMLContainer.getView());
        xMLContainer.getEditor().highlightLine(simpleNode.getStartingLine());
    }

    XMLContainer getMainContainer() {
        return this.mainContainer;
    }

    XMLContainer getSelectedContainer() {
        Component component = this.getSelectedComponent();
        if (component instanceof IView) {
            return ((IView)((Object)component)).getContainer();
        }
        return this.mainContainer;
    }

    private void resetIncludeImportTabs(XMLContainer xMLContainer, SimpleNode simpleNode) {
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            SimpleNode simpleNode2 = simpleNode.childAt(i);
            if (!simpleNode2.matchContent("include") && !simpleNode2.matchContent("import")) continue;
            this.checkDocument(xMLContainer, simpleNode2.getAttribute("href"));
        }
    }

    private void checkDocument(XMLContainer xMLContainer, String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        String string2 = xMLContainer.getCurrentDocumentLocation();
        String string3 = null;
        if (string.indexOf("://") > -1) {
            string3 = string;
        } else {
            File file = new File(string);
            if (!file.exists()) {
                if (string2 != null && (file = new File(new File(string2).getParentFile(), string)).exists()) {
                    string3 = file.toString();
                }
            } else {
                string3 = file.toString();
            }
        }
        if (string3 != null) {
            if (this.resolvedURI == null) {
                this.resolvedURI = new HashMap();
            }
            if (!this.resolvedURI.containsKey(string3)) {
                this.resolvedURI.put(string3, Boolean.TRUE);
                this.loadIncludeImportDocument(string3);
            }
        }
    }

    private void loadIncludeImportDocument(String string) {
        try {
            XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string, null);
            XMLContainer xMLContainer = this.buildNewContainer(true);
            xMLContainer.setDocumentInfo(this.getMainContainer().getDocumentInfo().cloneDocument());
            xMLContainer.setCurrentDocumentLocation(string);
            xMLContainer.setText(xMLFileData.getContent());
            this.addTabXMLContainer(null, xMLContainer);
            this.newDocument(xMLContainer);
        }
        catch (Throwable throwable) {
            System.out.println("Can't load [" + string + "]");
        }
    }

    private void addTabXMLContainer(String string, XMLContainer xMLContainer) {
        String string2;
        String string3 = string2 = xMLContainer.getCurrentDocumentLocation();
        if (string2 != null) {
            int n = string2.lastIndexOf("/");
            if (n == -1) {
                n = string2.lastIndexOf("\\");
            }
            if (n > -1) {
                string3 = string3.substring(n + 1);
            }
        }
        String string4 = "pawn.png";
        if (xMLContainer == this.mainContainer) {
            string4 = "pawn_glass_green.png";
        }
        if (string != null) {
            string3 = string;
        }
        int n = Math.max(0, this.getTabCount());
        if (xMLContainer == this.mainContainer) {
            n = 0;
        }
        if (this.initTemplatesTab) {
            --n;
        }
        this.insertTab(string3, new ImageIcon(this.getClass().getResource(string4)), xMLContainer.getView(), xMLContainer.getCurrentDocumentLocation(), n);
    }

    private void initTemplatesTab() {
        if (!this.initTemplatesTab) {
            this.templates = new XSLTTemplates(this);
            this.addTab("Templates", new ImageIcon(this.getClass().getResource("pawn_view.png")), this.templates);
            this.initTemplatesTab = true;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("update".equals(actionEvent.getActionCommand())) {
            this.newDocument(this.mainContainer);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Update links");
            jMenuItem.setToolTipText("Update included/imported documents");
            jMenuItem.setActionCommand("update");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

