/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.xslt.debug;

import com.japisoft.editix.xslt.debug.NodeDebug;
import com.japisoft.editix.xslt.debug.XPathNodeContextImpl;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xpath.XPathEvaluator;

public class Saxon2NodeDebug
implements NodeDebug {
    private InstructionInfo ii;
    private XPathContext xc;
    private String systemUri;

    public Saxon2NodeDebug(InstructionInfo instructionInfo, XPathContext xPathContext) {
        this.systemUri = instructionInfo.getSystemId();
        this.ii = instructionInfo;
        this.xc = xPathContext;
    }

    public String getSystemUri() {
        return this.systemUri;
    }

    public String getLocalName() {
        if (this.ii instanceof StyleElement) {
            StyleElement styleElement = (StyleElement)this.ii;
            return styleElement.getLocalPart();
        }
        return null;
    }

    public String getPrefix() {
        if (this.ii instanceof StyleElement) {
            StyleElement styleElement = (StyleElement)this.ii;
            return styleElement.getPrefix();
        }
        return null;
    }

    public int getLineNumber() {
        if (this.ii instanceof StyleElement) {
            StyleElement styleElement = (StyleElement)this.ii;
            return styleElement.getLineNumber();
        }
        return -1;
    }

    public String getAttributeValue(String string) {
        if (this.ii instanceof StyleElement) {
            StyleElement styleElement = (StyleElement)this.ii;
            return styleElement.getAttributeValue(string);
        }
        return null;
    }

    public String getNamespace() {
        if (this.ii instanceof StyleElement) {
            StyleElement styleElement = (StyleElement)this.ii;
            return styleElement.getURI();
        }
        return null;
    }

    public Object evalXPath(String string) throws Exception {
        SequenceIterator sequenceIterator = this.xc.getCurrentIterator();
        Item item = sequenceIterator.current();
        XPathEvaluator xPathEvaluator = new XPathEvaluator();
        return xPathEvaluator.evaluate(string, (Object)item);
    }

    public ArrayList getXPathContext() {
        ArrayList<XPathNodeContextImpl> arrayList = null;
        SequenceIterator sequenceIterator = this.xc.getCurrentIterator();
        try {
            Item item;
            Item item2 = sequenceIterator.current();
            sequenceIterator = sequenceIterator.getAnother();
            do {
                if ((item = sequenceIterator.next()) == null || !(item instanceof NodeInfo)) continue;
                NodeInfo nodeInfo = (NodeInfo)item;
                if (arrayList == null) {
                    arrayList = new ArrayList<XPathNodeContextImpl>();
                }
                arrayList.add(new XPathNodeContextImpl(nodeInfo.getNodeKind() == 3 ? "text()" : nodeInfo.getDisplayName(), nodeInfo.getLineNumber(), item.equals(item2)));
            } while (item != null);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return arrayList;
    }

    public ArrayList getVariables() {
        ArrayList arrayList = new ArrayList();
        if (this.ii instanceof NodeInfo) {
            this.scanVariablesParameters((NodeInfo)this.ii, arrayList, true);
        }
        if (arrayList.size() > 0) {
            Collections.reverse(arrayList);
            return arrayList;
        }
        return null;
    }

    public ArrayList getParameters() {
        ArrayList arrayList = new ArrayList();
        if (this.ii instanceof NodeInfo) {
            this.scanVariablesParameters((NodeInfo)this.ii, arrayList, false);
        }
        if (arrayList.size() > 0) {
            Collections.reverse(arrayList);
            return arrayList;
        }
        return null;
    }

    private void scanVariablesParameters(NodeInfo nodeInfo, ArrayList arrayList, boolean bl) {
    }
}

