/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser;

import com.japisoft.fastparser.ErrorParsingListener;
import com.japisoft.fastparser.HandlerException;
import com.japisoft.fastparser.Messages;
import com.japisoft.fastparser.ParseException;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.document.DocumentBuilder;
import com.japisoft.fastparser.document.DocumentBuilderException;
import com.japisoft.fastparser.document.DocumentBuilderImpl;
import com.japisoft.fastparser.node.NodeFactory;
import com.japisoft.fastparser.node.NodeFactoryImpl;
import com.japisoft.fastparser.node.ViewableNode;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;

public class Parser {
    private static byte[][] cAutomaton;
    private static byte[] cAutomatonDefaut;
    private static boolean[] cBufferMode;
    private static boolean[] cTransitionPreservedChar;
    protected String cCurrentFile;
    private NodeFactory nf;
    private DocumentBuilder db;
    private Reader cInput;
    private boolean buffering = true;
    private boolean flatView;
    private char[] fullContent = null;
    private boolean prolog = true;
    private boolean prologFound;
    private boolean ws;
    private boolean interruptParsing = false;
    private int mode = 2;
    private boolean currentNS = false;
    protected boolean realTimeCurrentNS = false;
    private boolean entityMode = false;
    public int line;
    public int lineText;
    public int col;
    public int offset;
    private boolean error = false;
    private boolean backgroundMode = false;
    private String attTmpName;
    private String attTmpLocalName;
    private String lastTag = null;
    private String lws = null;
    private boolean prologState = false;
    private boolean enabledNameSpace = true;
    private HashMap htNameSpaceURI = null;
    private boolean enabledComment = false;
    private String CDATABuffer = null;
    ErrorParsingListener errorSignal;

    public Parser() {
        this.prepareDocument(null);
        this.commonInit();
    }

    public Parser(Document document) {
        this.prepareDocument(document);
        this.commonInit();
    }

    private void commonInit() {
        this.preserveWhiteSpace(false);
        this.bufferingMode(true);
        this.htNameSpaceURI = new HashMap();
        this.htNameSpaceURI.put("xmlns", "");
        this.htNameSpaceURI.put("xml", "");
    }

    protected void prepareDocument(Document document) {
        this.setNodeFactory(NodeFactoryImpl.getFactory());
        this.setDocumentBuilder(new DocumentBuilderImpl(this.nf, this, document));
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nf = nodeFactory;
        this.setDocumentBuilder(new DocumentBuilderImpl(nodeFactory, this));
    }

    public NodeFactory getNodeFactory() {
        return this.nf;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.db = documentBuilder;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.db;
    }

    public Document getDocument() {
        return this.db.getDocument();
    }

    private static void initAutomaton() {
        byte[] byArray = new byte[22];
        byte by = 1;
        byte[] byArray2 = Parser.createStateDecider();
        byArray2[60] = (byte)(by + 2);
        Parser.blank(byArray2, by);
        byArray[by] = (byte)(by + 1);
        by = (byte)(by + 1);
        byte[] byArray3 = Parser.createStateDecider();
        byArray3[60] = (byte)(by + 1);
        byArray[by] = by;
        by = (byte)(by + 1);
        byte[] byArray4 = Parser.createStateDecider();
        Parser.blank(byArray4, (byte)(by + 1));
        byArray4[58] = (byte)(by + 14);
        byArray4[33] = (byte)(by + 9);
        byArray4[63] = (byte)(by + 18);
        byArray[by] = by;
        byArray4[62] = 1;
        by = (byte)(by + 1);
        byte[] byArray5 = Parser.createStateDecider();
        Parser.blank(byArray5, by);
        byArray[by] = (byte)(by + 1);
        byArray5[47] = (byte)(by + 5);
        byArray5[62] = 1;
        by = (byte)(by + 1);
        byte[] byArray6 = Parser.createStateDecider();
        byArray[by] = by;
        Parser.blank(byArray6, (byte)(by + 1));
        byArray6[61] = (byte)(by + 2);
        byArray6[58] = (byte)(by + 13);
        by = (byte)(by + 1);
        byte[] byArray7 = Parser.createStateDecider();
        Parser.blank(byArray7, by);
        byArray7[61] = (byte)(by + 1);
        by = (byte)(by + 1);
        byte[] byArray8 = Parser.createStateDecider();
        Parser.blank(byArray8, by);
        byArray8[34] = (byte)(by + 1);
        byArray8[39] = (byte)(by + 12);
        by = (byte)(by + 1);
        byte[] byArray9 = Parser.createStateDecider();
        byArray[by] = by;
        byArray9[34] = (byte)(by + 1);
        by = (byte)(by + 1);
        byte[] byArray10 = Parser.createStateDecider();
        byArray10[62] = 1;
        byArray10[47] = (byte)(by + 1);
        byArray10[63] = (byte)(by + 1);
        Parser.blank(byArray10, by);
        byArray[by] = (byte)(by - 4);
        by = (byte)(by + 1);
        byte[] byArray11 = Parser.createStateDecider();
        Parser.blank(byArray11, by);
        byArray11[62] = 1;
        by = (byte)(by + 1);
        byte[] byArray12 = Parser.createStateDecider();
        byArray12[62] = 1;
        byArray[by] = by;
        by = (byte)(by + 1);
        byte[] byArray13 = Parser.createStateDecider();
        byArray13[45] = (byte)(by + 1);
        byArray13[91] = (byte)(by + 3);
        byArray13[62] = 1;
        byArray[by] = (byte)(by - 1);
        by = (byte)(by + 1);
        byte[] byArray14 = Parser.createStateDecider();
        byArray14[45] = (byte)(by + 1);
        byArray[by] = by;
        by = (byte)(by + 1);
        byte[] byArray15 = Parser.createStateDecider();
        byArray15[45] = by;
        byArray15[62] = 1;
        byArray[by] = (byte)(by - 1);
        by = (byte)(by + 1);
        byte[] byArray16 = Parser.createStateDecider();
        byArray16[93] = (byte)(by + 1);
        byArray[by] = by;
        by = (byte)(by + 1);
        byte[] byArray17 = Parser.createStateDecider();
        byArray17[62] = 1;
        byArray17[93] = by;
        byArray[by] = (byte)(by - 1);
        by = (byte)(by + 1);
        byte[] byArray18 = Parser.createStateDecider();
        Parser.blank(byArray18, (byte)(by - 13));
        byArray[by] = by;
        byArray18[62] = 1;
        by = (byte)(by + 1);
        byte[] byArray19 = Parser.createStateDecider();
        byArray[by] = by;
        Parser.blank(byArray19, (byte)(by - 12));
        byArray19[61] = (byte)(by - 11);
        by = (byte)(by + 1);
        byte[] byArray20 = Parser.createStateDecider();
        byArray[by] = by;
        byArray20[39] = (byte)(by - 10);
        by = (byte)(by + 1);
        byte[] byArray21 = Parser.createStateDecider();
        byArray[by] = by;
        byArray21[63] = (byte)(by + 1);
        by = (byte)(by + 1);
        byte[] byArray22 = Parser.createStateDecider();
        byArray[by] = by;
        byArray22[62] = 1;
        cAutomatonDefaut = byArray;
        cAutomaton = new byte[][]{null, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8, byArray9, byArray10, byArray11, byArray12, byArray13, byArray14, byArray15, byArray16, byArray17, byArray18, byArray19, byArray20, byArray21, byArray22};
        cBufferMode = new boolean[]{false, false, true, true, false, true, false, false, true, false, true, false, false, false, false, true, false, true, true, true, false, false};
        cTransitionPreservedChar = new boolean[cBufferMode.length];
        Parser.cTransitionPreservedChar[2] = true;
    }

    private static byte[] createStateDecider() {
        return new byte[255];
    }

    public void cdataEnabled(boolean bl) {
        Parser.cBufferMode[14] = bl;
    }

    public boolean isCdataEnabled() {
        return cBufferMode[14];
    }

    public void preserveComment(boolean bl) {
        Parser.cBufferMode[13] = bl;
    }

    private static void blank(byte[] byArray, byte by) {
        byArray[32] = by;
        byArray[9] = by;
        byArray[13] = by;
        byArray[10] = by;
    }

    public void setReader(Reader reader) {
        if (reader == null) {
            throw new RuntimeException("Null reader ?");
        }
        this.cInput = reader;
    }

    protected boolean hasReader() {
        return this.cInput != null;
    }

    public void setInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new RuntimeException("Null input stream ?");
        }
        this.cInput = new InputStreamReader(inputStream);
    }

    public void bufferingMode(boolean bl) {
        this.buffering = bl;
    }

    public boolean hasBufferingMode() {
        return this.buffering;
    }

    public boolean isFlatView() {
        return this.flatView;
    }

    public void setFlatView(boolean bl) {
        this.flatView = bl;
    }

    public void setText(String string) {
        if (string == null) {
            throw new RuntimeException("Null text ?");
        }
        this.cInput = new StringReader(string);
    }

    public void setContent(char[] cArray) {
        this.fullContent = cArray;
    }

    public void setMandatoryProlog(boolean bl) {
        this.prolog = bl;
    }

    public boolean isMandatoryProlog() {
        return this.prolog;
    }

    public void preserveWhiteSpace(boolean bl) {
        this.ws = bl;
    }

    public boolean isPreserveWhiteSpace() {
        return this.ws;
    }

    public void interruptParsing() {
        this.interruptParsing = true;
    }

    public boolean isInterrupted() {
        return this.interruptParsing;
    }

    public void setParsingMode(int n) {
        this.mode = n;
    }

    public int getParsingMode() {
        return this.mode;
    }

    private char hexaToChar(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            throw new RuntimeException(Messages.ERROR_ENTITY2);
        }
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = n2 - i - 1 << 2;
            if (c >= '0' && c <= '9') {
                n += c - 48 << n3;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                n += 10 + c - 97 << n3;
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                n += 10 + c - 65 << n3;
                continue;
            }
            throw new RuntimeException(Messages.ERROR_ENTITY3 + " :" + string);
        }
        return (char)n;
    }

    public boolean hasError() {
        return this.error;
    }

    public void parse() throws ParseException {
        block93: {
            int n;
            if (this.nf == null) {
                throw new ParseException("No factory for node");
            }
            if (this.cInput == null && this.fullContent == null) {
                throw new ParseException("No document to parse");
            }
            char c = '\u0000';
            int n2 = n = 1;
            byte[] byArray = cAutomaton[n];
            this.line = 1;
            this.offset = 0;
            this.prologFound = false;
            this.interruptParsing = false;
            this.error = false;
            if (this.db != null) {
                if (this.mode == 1) {
                    this.db.setCheckForCloseTag(false);
                } else {
                    this.db.setCheckForCloseTag(true);
                }
                if (this.flatView) {
                    this.db.setFlatView(true);
                }
            }
            char[] cArray = null;
            int n3 = 0;
            if (this.fullContent != null) {
                cArray = this.fullContent;
                n3 = this.fullContent.length;
            } else {
                cArray = new char[2048];
            }
            Object object = new char[16];
            int n4 = 0;
            char[] cArray2 = new char[64];
            int n5 = 0;
            try {
                if (this.fullContent == null) {
                    n3 = this.cInput.read(cArray);
                }
                if (n3 != -1) {
                    block23: do {
                        try {
                            for (int i = 0; i < n3; ++i) {
                                Object object2;
                                char c2 = cArray[i];
                                if (this.interruptParsing) continue block23;
                                int n6 = cAutomatonDefaut[n];
                                this.realTimeCurrentNS = false;
                                if (c2 == ':' && (n == 3 || n == 5)) {
                                    this.currentNS = true;
                                    this.realTimeCurrentNS = true;
                                }
                                try {
                                    if ((c2 & 0xFF00) == 0) {
                                        n = byArray[c2 & 0xFF];
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                                if (n == 0) {
                                    n = n6;
                                }
                                if (n != n2) {
                                    if (cBufferMode[n2]) {
                                        if (n2 == 19) {
                                            n2 = 8;
                                        }
                                        if (n4 > 0) {
                                            if (n2 != 13 || this.enabledComment) {
                                                object2 = new String((char[])object, 0, n4);
                                                this.fireItemFound(n2, (String)object2);
                                            }
                                            n4 = 0;
                                        } else if (n2 == 8 && this.attTmpName != null) {
                                            this.fireItemFound(8, "");
                                        }
                                    } else if (cTransitionPreservedChar[n]) {
                                        if (c2 == '&') {
                                            this.entityMode = true;
                                            cArray2[n5++] = c2;
                                        } else {
                                            object[n4++] = c2;
                                            if (n4 == ((char[])object).length) {
                                                object2 = new char[n4 * 2];
                                                System.arraycopy(object, 0, object2, 0, n4);
                                                object = object2;
                                            }
                                        }
                                    }
                                }
                                c = c2;
                                byArray = cAutomaton[n];
                                if (cBufferMode[n]) {
                                    if (n == n2 || n == 5 || n == 10) {
                                        if (c2 == '&' && n != 15) {
                                            this.entityMode = true;
                                            cArray2[n5++] = c2;
                                        } else if (!this.entityMode) {
                                            object[n4++] = c2;
                                        } else {
                                            if (c2 == ' ') {
                                                throw new RuntimeException(Messages.ERROR_ENTITY4);
                                            }
                                            if (c2 == ';') {
                                                cArray2[n5++] = c2;
                                                if (n5 == 2) {
                                                    throw new RuntimeException(Messages.ERROR_ENTITY5);
                                                }
                                                if (cArray2[1] == '#') {
                                                    if (n5 == 3) {
                                                        throw new RuntimeException(Messages.ERROR_ENTITY5);
                                                    }
                                                    int n7 = 0;
                                                    try {
                                                        if (cArray2[2] == 'x') {
                                                            if (n5 == 4) {
                                                                throw new RuntimeException(Messages.ERROR_ENTITY5);
                                                            }
                                                            object2 = new String(cArray2, 3, n5 - 4);
                                                            n7 = this.hexaToChar((String)object2);
                                                        } else {
                                                            object2 = new String(cArray2, 2, n5 - 3);
                                                            try {
                                                                n7 = Integer.parseInt((String)object2);
                                                            }
                                                            catch (Throwable throwable) {
                                                                throw new RuntimeException(Messages.ERROR_ENTITY6 + " " + (String)object2);
                                                            }
                                                        }
                                                        object[n4++] = (char)n7;
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        throw new RuntimeException(Messages.ERROR_ENTITY1 + " " + new String(cArray2, 1, n5 - 2));
                                                    }
                                                }
                                                object2 = new String(cArray2, 1, n5 - 2);
                                                if ("lt".equals(object2)) {
                                                    object[n4++] = 60;
                                                } else if ("gt".equals(object2)) {
                                                    object[n4++] = 62;
                                                } else if ("quot".equals(object2)) {
                                                    object[n4++] = 34;
                                                } else if ("apos".equals(object2)) {
                                                    object[n4++] = 39;
                                                } else if ("amp".equals(object2)) {
                                                    object[n4++] = 38;
                                                } else {
                                                    this.unknownEntityDetected((String)object2);
                                                    if (n4 + n5 >= ((char[])object).length) {
                                                        char[] cArray3 = new char[n4 * 2];
                                                        System.arraycopy(object, 0, cArray3, 0, n4);
                                                        object = cArray3;
                                                    }
                                                    System.arraycopy(cArray2, 0, object, n4, n5);
                                                    n4 += n5;
                                                }
                                                n5 = 0;
                                                this.entityMode = false;
                                            } else {
                                                cArray2[n5++] = c2;
                                            }
                                        }
                                        if (n4 == ((char[])object).length) {
                                            object2 = new char[n4 * 2];
                                            System.arraycopy(object, 0, object2, 0, n4);
                                            object = object2;
                                        }
                                    }
                                } else if ('/' == c2 && n != 21) {
                                    if (this.CDATABuffer != null && n != 15) {
                                        if (this.db != null) {
                                            this.db.addTextNode(this.CDATABuffer.substring(6, this.CDATABuffer.length()));
                                        }
                                        this.CDATABuffer = null;
                                    }
                                    if (n != 11 && n != 13 && n != 15 && this.db != null) {
                                        this.db.closeNode();
                                    }
                                } else if (n != 15 && this.CDATABuffer != null && this.CDATABuffer != null && n != 15) {
                                    if (this.db != null) {
                                        this.db.addTextNode(this.CDATABuffer.substring(6, this.CDATABuffer.length()));
                                    }
                                    this.CDATABuffer = null;
                                }
                                if (n == 2 && n2 != 2) {
                                    this.lineText = this.line;
                                }
                                n2 = n;
                                ++this.col;
                                if (c2 == '\n') {
                                    ++this.line;
                                    this.col = 0;
                                }
                                ++this.offset;
                            }
                        }
                        catch (Throwable throwable) {
                            this.notifyError(throwable);
                            if (this.mode == 0) {
                                n = 1;
                                continue;
                            }
                            throw throwable;
                        }
                    } while ((n3 = this.cInput != null ? this.cInput.read(cArray) : -1) != -1);
                }
                if (this.interruptParsing || this.error || this.db == null || this.db.isTerminated()) break block93;
                try {
                    this.line = ((ViewableNode)((Object)this.db.getDocument().getRoot())).getStartingLine();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.notifyError(new RuntimeException(Messages.ERROR_TAG1));
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                this.htNameSpaceURI = null;
                ParseException parseException = null;
                if ("true".equals(System.getProperty("fp.debug"))) {
                    throwable.printStackTrace();
                }
                parseException = throwable instanceof ParseException ? (ParseException)throwable : new ParseException(Messages.ERROR2 + (this.cCurrentFile != null ? this.cCurrentFile : "") + " " + Messages.LINE + " " + (this.line + 1));
                parseException.setCauseBy(throwable.getMessage());
                parseException.setCaret(this.offset);
                parseException.setLine(this.line + 1);
                parseException.setCol(this.col);
                if (throwable instanceof HandlerException) {
                    ((HandlerException)throwable).getCause().printStackTrace();
                }
                if (this.db != null) {
                    this.db.dispose();
                }
                throw parseException;
            }
            finally {
                if (this.cInput != null) {
                    try {
                        this.cInput.close();
                    }
                    catch (IOException iOException) {}
                }
                this.cInput = null;
            }
        }
        if (this.db != null) {
            this.db.dispose();
        }
        this.htNameSpaceURI = null;
    }

    private void notifyError(Throwable throwable) {
        this.error = true;
        if (throwable.getMessage() != null) {
            this.fireErrorFound(throwable.getMessage(), this.offset, this.line, this.col);
        } else {
            this.fireErrorFound(Messages.ERROR1, this.offset, this.line, this.col);
        }
    }

    protected void fireErrorFound(String string, int n, int n2, int n3) {
        if (this.errorSignal != null) {
            this.errorSignal.parsingError(string, n, n2, n3);
        }
    }

    public void setEnabledNameSpace(boolean bl) {
        this.enabledNameSpace = bl;
        if (!bl) {
            Parser.cAutomaton[2][58] = 2;
            Parser.cAutomaton[4][58] = 4;
        } else {
            Parser.cAutomaton[2][58] = 16;
            Parser.cAutomaton[4][58] = 17;
        }
    }

    public boolean isEnabledNameSpace() {
        return this.enabledNameSpace;
    }

    public void setEnabledComment(boolean bl) {
        this.enabledComment = bl;
    }

    public boolean isEnabledComment() {
        return this.enabledComment;
    }

    protected void fireItemFound(int n, String string) throws ParseException {
        try {
            if (this.CDATABuffer != null && n != 15) {
                this.db.addTextNode(this.CDATABuffer.substring(6, this.CDATABuffer.length()));
                this.CDATABuffer = null;
            }
            switch (n) {
                case 1: {
                    this.lws = string;
                    break;
                }
                case 2: {
                    if (this.ws && this.lws != null) {
                        string = this.lws + string;
                    }
                    this.db.addTextNode(string);
                    this.lws = null;
                    break;
                }
                case 3: {
                    boolean bl = false;
                    if (string.startsWith("?xml")) {
                        this.prologFound = true;
                        bl = true;
                    }
                    if (!this.prologFound && bl && !string.startsWith("?xml")) {
                        throw new ParseException(Messages.ERROR_PROLOG);
                    }
                    if (!this.currentNS) {
                        if (string.startsWith("/")) {
                            this.db.closeNode(null, string.substring(1));
                        } else if (!bl) {
                            this.db.openNode(null, null, string);
                        }
                    } else {
                        this.currentNS = false;
                    }
                    this.lastTag = string;
                    break;
                }
                case 5: {
                    this.attTmpName = string;
                    break;
                }
                case 8: {
                    if (this.lastTag == null || this.lastTag.startsWith("?")) break;
                    if (this.currentNS) {
                        boolean bl = true;
                        if (this.enabledNameSpace && "xmlns".equals(this.attTmpName)) {
                            bl = false;
                            this.htNameSpaceURI.put(this.attTmpLocalName, string);
                            this.db.setNameSpace(this.attTmpLocalName, string);
                        }
                        if (bl) {
                            this.db.setAttribute(this.attTmpName, (String)this.htNameSpaceURI.get(this.attTmpName), this.attTmpLocalName, string);
                        }
                    } else if (this.enabledNameSpace && "xmlns".equals(this.attTmpName)) {
                        this.db.setNameSpace(null, string);
                    } else {
                        this.db.setAttribute(null, null, this.attTmpName, string);
                    }
                    this.currentNS = false;
                    break;
                }
                case 10: {
                    if ("/".equals(string)) {
                        this.db.closeNode();
                        break;
                    }
                    if (!this.prologFound || this.prologState) break;
                    this.prologState = true;
                    break;
                }
                case 13: {
                    this.db.addCommentNode(string);
                    break;
                }
                case 15: {
                    if (this.CDATABuffer == null) {
                        this.CDATABuffer = string;
                        break;
                    }
                    this.CDATABuffer = this.CDATABuffer + "]" + string;
                    break;
                }
                case 17: {
                    if (this.lastTag.startsWith("/")) {
                        this.db.closeNode(this.lastTag.substring(1), string);
                        break;
                    }
                    this.db.openNode(this.lastTag, (String)this.htNameSpaceURI.get(this.lastTag), string);
                    break;
                }
                case 18: {
                    this.attTmpLocalName = string;
                }
            }
        }
        catch (DocumentBuilderException documentBuilderException) {
            if ("true".equals(System.getProperty("fp.debug"))) {
                documentBuilderException.printStackTrace();
            }
            ParseException parseException = new ParseException(documentBuilderException.getMessage());
            throw parseException;
        }
    }

    protected void unknownEntityDetected(String string) {
    }

    public boolean isBackgroundMode() {
        return this.backgroundMode;
    }

    public void setBackgroundMode(boolean bl) {
        this.backgroundMode = bl;
    }

    public void setErrorSignal(ErrorParsingListener errorParsingListener) {
        this.errorSignal = errorParsingListener;
    }

    public static void main(String[] stringArray) throws Throwable {
        Parser parser = new Parser();
        parser.setReader(new FileReader("C:/test.xml"));
        parser.parse();
        Document document = parser.getDocument();
        document.write(System.out);
    }

    static {
        Parser.initAutomaton();
    }
}

