/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.findreplace;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.JTextComponent;

class FindReplaceManager {
    boolean forward = true;
    boolean scope_all = true;
    boolean caseSensitive = false;
    boolean wholeWord = false;
    boolean regularExpressions = false;
    boolean wrapSearch = false;
    boolean incremental = false;
    char[] motif = null;
    int documentStart = -1;
    int documentEnd = -1;
    int caret = -1;
    int nextCaret = -1;
    int motifCaret = -1;
    int lastREMatchingEnd = -1;
    final int DCS = -32;

    FindReplaceManager() {
    }

    void init() {
        this.caret = -1;
        this.motifCaret = -1;
        this.documentStart = -1;
        this.documentEnd = -1;
        this.lastREMatchingEnd = -1;
    }

    int getMotifLength() {
        if (!this.regularExpressions) {
            return this.motif.length;
        }
        return this.lastREMatchingEnd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int nextSearch(JTextComponent jTextComponent, char[] cArray) {
        if (this.motif == null) return -1;
        if (this.motif.length == 0) {
            return -1;
        }
        if (this.motifCaret == 0 && !this.forward) {
            this.motifCaret = -1;
        }
        if (this.motifCaret == this.motif.length) {
            this.motifCaret = -1;
        }
        if (this.motifCaret >= this.motif.length) {
            this.motifCaret = this.motif.length - 2;
        }
        if (this.motifCaret <= -1 || this.motifCaret >= this.motif.length) {
            this.resetMotifCaret();
        }
        if (this.documentStart == -1) {
            this.documentStart = this.scope_all ? 0 : jTextComponent.getSelectionStart();
        }
        if (this.documentEnd == -1) {
            this.documentEnd = this.scope_all ? jTextComponent.getDocument().getLength() : jTextComponent.getSelectionEnd() + 1;
        }
        if (this.documentEnd >= jTextComponent.getDocument().getLength()) {
            this.documentEnd = jTextComponent.getDocument().getLength();
        }
        if (this.caret <= -1) {
            int n = this.scope_all ? jTextComponent.getCaretPosition() : (this.caret = this.forward ? this.documentStart : this.documentEnd - 1);
            if (this.caret >= this.documentEnd) {
                --this.caret;
            }
        }
        this.nextCaret = this.caret;
        int n = this.documentEnd;
        if (n == 0) {
            return -1;
        }
        boolean bl = this.caret < this.documentStart || this.caret >= this.documentEnd;
        char[] cArray2 = cArray;
        if (cArray2 == null) {
            cArray2 = jTextComponent.getText().toCharArray();
        }
        if (bl && this.scope_all) {
            this.checkCaretBoundary(this.documentEnd);
            if (this.caret < this.documentStart) return -1;
            if (this.caret >= this.documentEnd) {
                return -1;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        boolean bl3 = false;
        while (!bl) {
            if (!this.regularExpressions) {
                int n2 = this.simpleSearch(cArray2);
                if (n2 > -1) {
                    return n2;
                }
                this.incCaret();
            } else {
                try {
                    Pattern pattern = null;
                    pattern = !this.caseSensitive ? Pattern.compile(new String(this.motif), 2) : Pattern.compile(new String(this.motif));
                    Matcher matcher = pattern.matcher(jTextComponent.getText());
                    if (matcher.find(this.nextCaret)) {
                        this.nextCaret = matcher.end();
                        this.lastREMatchingEnd = matcher.end() - matcher.start();
                        if (matcher.end() <= this.documentEnd) return matcher.start();
                        this.nextCaret = this.documentEnd;
                    } else {
                        this.nextCaret = this.documentEnd;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return -1;
                }
            }
            if (!(bl = this.nextCaret < this.documentStart || this.nextCaret >= this.documentEnd) || !this.wrapSearch || !this.scope_all) continue;
            this.checkCaretBoundary(this.documentEnd);
            if (!bl3) {
                if (this.nextCaret < this.documentStart) return -1;
                if (this.nextCaret >= this.documentEnd) {
                    return -1;
                }
                boolean bl4 = false;
                bl = bl4;
            }
            bl3 = true;
        }
        return -1;
    }

    int simpleSearch(char[] cArray) {
        if (this.matchChar(cArray[this.nextCaret], this.motif[this.motifCaret])) {
            this.incMotifCaret();
            if (this.matchMotif()) {
                boolean bl = true;
                this.incCaret();
                if (this.wholeWord) {
                    bl = false;
                    if (this.isWhitespaceFor(this.forward ? this.nextCaret : this.nextCaret + (this.motif.length + 1), cArray) && this.isWhitespaceFor(this.forward ? this.nextCaret - this.motif.length - 1 : this.nextCaret, cArray)) {
                        bl = true;
                    }
                }
                if (bl) {
                    int n;
                    int n2 = n = this.forward ? this.nextCaret - this.motif.length : this.nextCaret + 1;
                    if (this.nextCaret < 0) {
                        this.nextCaret = 0;
                    }
                    return n;
                }
                this.resetMotifCaret();
            }
        } else {
            this.resetMotifCaret();
        }
        return -1;
    }

    void checkCaretBoundary(int n) {
        if (this.wrapSearch) {
            this.nextCaret = this.nextCaret < 0 ? n - 1 : 0;
        }
    }

    boolean isWhitespaceFor(int n, char[] cArray) {
        if (n < 0) {
            return true;
        }
        if (n >= cArray.length - 1) {
            return true;
        }
        char c = cArray[n];
        if (c == ':' || c == '!' || c == ',' || c == '.' || c == ';' || c == '[' || c == ']' || c == '(' || c == ')' || c == '{' || c == '}') {
            return true;
        }
        return Character.isWhitespace(c);
    }

    boolean matchMotif() {
        return this.forward ? this.motifCaret == this.motif.length : this.motifCaret == -1;
    }

    void resetMotifCaret() {
        this.motifCaret = this.forward ? 0 : this.motif.length - 1;
    }

    void incCaret() {
        this.nextCaret = this.forward ? this.nextCaret + 1 : this.nextCaret - 1;
    }

    void incMotifCaret() {
        this.motifCaret = this.forward ? this.motifCaret + 1 : this.motifCaret - 1;
    }

    boolean matchChar(char c, char c2) {
        if (this.caseSensitive) {
            return c == c2;
        }
        if (Character.isLetter(c) && Character.isLetter(c2)) {
            return c + -32 == c2 || c2 + -32 == c || c == c2;
        }
        return c == c2;
    }
}

