/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.multipanes;

import com.japisoft.multipanes.MultiPanes;
import com.japisoft.multipanes.TitledPane;
import com.japisoft.multipanes.TitledPaneModel;
import java.util.ArrayList;

public class DefaultTitledPaneModel
implements TitledPaneModel {
    private ArrayList model;
    private MultiPanes panes;

    public DefaultTitledPaneModel(MultiPanes multiPanes) {
        this.panes = multiPanes;
        this.model = new ArrayList();
    }

    public void addTitledPane(TitledPane titledPane) {
        this.model.add(titledPane);
        this.panes.updateView();
    }

    public void insertTitledPane(int n, TitledPane titledPane) {
        this.model.add(n, titledPane);
        this.panes.updateView();
    }

    public void removeTitledPane(TitledPane titledPane) {
        this.model.remove(titledPane);
        titledPane.dispose();
        this.panes.updateView();
    }

    public int getTitledPaneIndex(TitledPane titledPane) {
        return this.model.indexOf(titledPane);
    }

    public TitledPane getTitledPaneByName(String string) {
        if (string == null) {
            throw new RuntimeException("Illegal null name");
        }
        for (int i = 0; i < this.model.size(); ++i) {
            TitledPane titledPane = (TitledPane)this.model.get(i);
            if (!string.equals(titledPane.getName())) continue;
            return titledPane;
        }
        return null;
    }

    public TitledPane getTitledPaneAt(int n) {
        if (n >= this.model.size()) {
            return null;
        }
        return (TitledPane)this.model.get(n);
    }

    public int getTitledPaneCount() {
        return this.model.size();
    }
}

