/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.designer.data;

import com.japisoft.framework.xml.grammar.GrammarAttribute;
import com.japisoft.framework.xml.grammar.GrammarContainer;
import com.japisoft.framework.xml.grammar.GrammarElement;
import com.japisoft.framework.xml.grammar.GrammarNode;
import com.japisoft.framework.xml.grammar.GrammarText;
import com.japisoft.framework.xml.grammar.GrammarType;
import com.japisoft.xmlform.designer.data.AbstractTreeNode;
import java.util.List;

public class GrammarNodeTreeNode
extends AbstractTreeNode {
    private GrammarNode node = null;

    public GrammarNodeTreeNode(GrammarNode grammarNode) {
        this.node = grammarNode;
        GrammarType grammarType = grammarNode.getType();
        List<GrammarNode> list = grammarType.getValues();
        if (list != null && !(grammarNode instanceof GrammarText) && !(grammarNode instanceof GrammarAttribute)) {
            for (GrammarNode grammarNode2 : list) {
                GrammarNodeTreeNode grammarNodeTreeNode = new GrammarNodeTreeNode(grammarNode2);
                grammarNodeTreeNode.parent = this;
                this.addChild(grammarNodeTreeNode);
            }
        }
    }

    public String toString() {
        return this.node.getName();
    }

    public GrammarNode getSource() {
        return this.node;
    }

    public GrammarNodeTreeNode resolveRelativeXPath(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
            return this;
        }
        if (string.startsWith("@")) {
            String string2 = string.substring(1);
            for (int i = 0; i < this.getChildCount(); ++i) {
                GrammarNodeTreeNode grammarNodeTreeNode = (GrammarNodeTreeNode)this.getChildAt(i);
                if (!(grammarNodeTreeNode.node instanceof GrammarAttribute) || !string2.equals(grammarNodeTreeNode.node.getName())) continue;
                return grammarNodeTreeNode;
            }
        } else {
            int n = string.lastIndexOf("/");
            if (n > -1) {
                string = string.substring(0, n);
            }
            for (n = 0; n < this.getChildCount(); ++n) {
                GrammarNodeTreeNode grammarNodeTreeNode = (GrammarNodeTreeNode)this.getChildAt(n);
                if (grammarNodeTreeNode.node instanceof GrammarContainer) {
                    GrammarNodeTreeNode grammarNodeTreeNode2 = grammarNodeTreeNode.resolveRelativeXPath(string);
                    if (grammarNodeTreeNode2 == null) continue;
                    return grammarNodeTreeNode2;
                }
                if (!(grammarNodeTreeNode.node instanceof GrammarElement ? string.equals(grammarNodeTreeNode.node.getName()) : grammarNodeTreeNode.node instanceof GrammarText && "text()".equals(string))) continue;
                return grammarNodeTreeNode;
            }
        }
        return null;
    }

    public String getId() {
        return this.toXPath();
    }

    public String toXPath() {
        if (this.node instanceof GrammarContainer) {
            return ((GrammarNodeTreeNode)this.getParent()).toXPath();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.node instanceof GrammarAttribute) {
            stringBuffer.append("@").append(this.toString());
        } else if (this.node.getType().getValues() == null) {
            if (!"#text".equals(this.toString())) {
                stringBuffer.append(this.toString());
                stringBuffer.append("/");
            }
            stringBuffer.append("text()");
        } else {
            stringBuffer.append(this.toString());
        }
        stringBuffer.insert(0, "/");
        if (this.parent instanceof GrammarNodeTreeNode) {
            stringBuffer.insert(0, ((GrammarNodeTreeNode)this.parent).toXPath());
        }
        return stringBuffer.toString();
    }
}

