/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action.edit;

import com.japisoft.fastparser.document.Document;
import com.japisoft.xmlpad.action.XMLAction;
import com.japisoft.xmlpad.dialog.DialogManager;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SurroundTagAction
extends XMLAction {
    public static final String ID = SurroundTagAction.class.getName();

    public boolean notifyAction() {
        String[] stringArray;
        String string = this.container.getEditor().getSelectedText();
        if (string == null && (stringArray = this.container.getCurrentElementNode()) != null) {
            int n = stringArray.getStartingOffset();
            int n2 = stringArray.getStoppingOffset();
            this.container.getEditor().select(n, n2 + 1);
            string = this.container.getEditor().getSelectedText();
        }
        try {
            if (string != null) {
                stringArray = null;
                if (this.container.getRootNode() != null) {
                    Document document = this.container.getRootNode().getDocument();
                    stringArray = document.getElementDictionnary();
                }
                SurroundTagPane surroundTagPane = new SurroundTagPane(stringArray);
                if (DialogManager.showDialog(SwingUtilities.getWindowAncestor(this.container.getView()), "Surrond", "Surround action", "Surround your selection by a tag", null, surroundTagPane) == 0) {
                    String string2 = surroundTagPane.getStartingTag();
                    String string3 = surroundTagPane.getEndingTag();
                    if (string2 == null) {
                        return false;
                    }
                    String string4 = string2 + string + string3;
                    this.container.getEditor().replaceSelection(string4);
                    return true;
                }
                return false;
            }
            JOptionPane.showMessageDialog(this.container.getView(), "No selection found", "Error", 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("Can't surround");
        }
        return false;
    }

    class SurroundTagPane
    extends JPanel {
        String[] dico;
        JComboBox cb;

        public SurroundTagPane(String[] stringArray) {
            this.dico = stringArray;
            this.initUI();
            this.setPreferredSize(new Dimension(300, 200));
        }

        public void addNotify() {
            super.addNotify();
            this.cb.requestFocus();
        }

        private void initUI() {
            if (this.dico == null) {
                this.cb = new JComboBox();
            } else {
                DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                for (int i = 0; i < this.dico.length; ++i) {
                    if (this.dico[i] == null) continue;
                    defaultComboBoxModel.addElement(this.dico[i]);
                }
                this.cb = new JComboBox(defaultComboBoxModel);
            }
            this.cb.setEditable(true);
            this.cb.setPreferredSize(new Dimension(250, 20));
            this.setLayout(new FlowLayout());
            this.add(this.cb);
        }

        public String getStartingTag() {
            if (this.cb.getSelectedItem() == null) {
                return null;
            }
            if (this.cb.getSelectedItem() instanceof TagDescriptor) {
                return ((TagDescriptor)this.cb.getSelectedItem()).getStartingTag();
            }
            return "<" + (String)this.cb.getSelectedItem() + ">";
        }

        public String getEndingTag() {
            if (this.cb.getSelectedItem() == null) {
                return null;
            }
            if (this.cb.getSelectedItem() instanceof TagDescriptor) {
                return ((TagDescriptor)this.cb.getSelectedItem()).getEndingTag();
            }
            return "</" + (String)this.cb.getSelectedItem() + ">";
        }
    }
}

