/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.editor;

import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.editor.WrappedXMLView;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLTextView;
import com.japisoft.xmlpad.editor.XMLView;
import com.japisoft.xmlpad.editor.XMLViewable;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class XMLEditorKit
extends DefaultEditorKit
implements ViewFactory {
    private XMLDocument doc;
    private boolean syntaxColor = true;
    private boolean dtdMode = false;
    public boolean wrappedMode = false;
    XMLViewable lastView;
    private boolean displaySpace = false;

    public XMLEditorKit(XMLDocument xMLDocument) {
        this.doc = xMLDocument;
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public void setSyntaxColor(boolean bl) {
        this.syntaxColor = bl;
        if (!bl && this.lastView != null) {
            this.lastView.setSyntaxColor(false);
        }
    }

    public void setDTDMode(boolean bl) {
        this.dtdMode = bl;
        if (bl && this.lastView != null) {
            this.lastView.setDTDMode(true);
        }
    }

    public void setWrappedMode(boolean bl) {
        this.wrappedMode = bl;
    }

    public void setDisplaySpace(boolean bl) {
        this.displaySpace = bl;
        if (this.lastView != null && this.lastView instanceof XMLTextView) {
            ((XMLTextView)this.lastView).setDisplaySpace(bl);
        }
    }

    public boolean isDisplaySpace() {
        return this.displaySpace;
    }

    public View create(Element element) {
        if (this.syntaxColor) {
            this.lastView = SharedProperties.WRAPPED_LINE ? new WrappedXMLView(element) : (SharedProperties.FULL_TEXT_VIEW ? new XMLTextView(element, this.displaySpace) : new XMLView(element));
            return (View)((Object)this.lastView);
        }
        this.lastView = new XMLView(element);
        return (View)((Object)this.lastView);
    }

    public Document createDefaultDocument() {
        return this.doc;
    }

    public String getContentType() {
        return "text/plain";
    }
}

