/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.job.JobAdapter;
import com.japisoft.framework.job.JobManager;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.helper.ContentAssistantUI;
import com.japisoft.xmlpad.helper.handler.AbstractHelperHandler;
import com.japisoft.xmlpad.helper.handler.schema.AbstractTagHandler;
import com.japisoft.xmlpad.helper.model.Descriptor;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;

public class HelperManager {
    private XMLContainer container;
    private ArrayList result = null;
    private String newTitleTmp = null;
    Runnable fasterTask = null;
    HelperManagerJob managerJob = null;
    private SimpleNode currentNode;
    private String currentTitle;
    private boolean currentInsertBefore;
    private int currentOffset;
    private String currentActivatorString;
    private ArrayList activeHelperHandler = null;
    static boolean HELPER_WORKING = false;
    private ContentAssistantUI uiHelper = null;
    private boolean enabled = true;
    private ArrayList handlers = null;

    public HelperManager(XMLContainer xMLContainer) {
        this.container = xMLContainer;
    }

    public void dispose() {
        this.container = null;
        this.result = null;
        if (this.uiHelper != null) {
            this.uiHelper.dispose();
            this.uiHelper = null;
        }
        for (int i = 0; i < this.getHelperHandlerCount(); ++i) {
            this.getHelperHandler(i).dispose();
        }
        this.handlers = null;
        if (this.managerJob != null) {
            this.managerJob.dispose();
            this.managerJob = null;
        }
        this.activeHelperHandler = null;
        this.fasterTask = null;
    }

    public boolean activateContentAssistant(SimpleNode simpleNode, String string, boolean bl, int n, String string2) {
        if (!this.enabled) {
            return false;
        }
        if (this.container.getDocument().isInsideComment(n) || this.container.getDocument().isInsideCDATA(n)) {
            return false;
        }
        boolean bl2 = false;
        for (int i = this.getHelperHandlerCount() - 1; i >= 0; --i) {
            if (!this.getHelperHandler(i).isEnabled() || !this.getHelperHandler(i).haveDescriptors(simpleNode, this.container.getDocument(), bl, n, string2)) continue;
            Debug.debug("Match " + this.getHelperHandler(i));
            if (this.getHelperHandler(i).mustBeJobSynchronized()) {
                bl2 = true;
            }
            if (this.activeHelperHandler == null) {
                this.activeHelperHandler = new ArrayList();
            }
            this.activeHelperHandler.add(0, this.getHelperHandler(i));
        }
        if (this.activeHelperHandler == null || this.activeHelperHandler.size() == 0) {
            return false;
        }
        this.currentNode = simpleNode;
        this.currentTitle = string;
        this.currentInsertBefore = bl;
        this.currentOffset = n;
        this.currentActivatorString = string2;
        if (this.managerJob == null) {
            this.managerJob = new HelperManagerJob();
        }
        this.managerJob.aynchronousMode = bl2;
        if (!bl2) {
            this.managerJob.run();
            this.managerJob.dispose();
            return this.result.size() > 0;
        }
        if (this.fasterTask == null) {
            this.fasterTask = new Runnable(){

                public void run() {
                    JobManager.addJob(HelperManager.this.managerJob);
                }
            };
        }
        SwingUtilities.invokeLater(this.fasterTask);
        return true;
    }

    private ArrayList prepareDescriptors(SimpleNode simpleNode, XMLDocument xMLDocument, boolean bl, int n, String string) {
        this.newTitleTmp = null;
        if (this.result == null) {
            this.result = new ArrayList();
        } else {
            this.result.removeAll(this.result);
        }
        for (int i = 0; i < this.activeHelperHandler.size(); ++i) {
            Descriptor[] descriptorArray = ((AbstractHelperHandler)this.activeHelperHandler.get(i)).resolveContentAssistant(this.currentNode, this.container.getDocument(), this.currentInsertBefore, this.currentOffset, this.currentActivatorString);
            if (this.newTitleTmp == null && descriptorArray != null && descriptorArray.length > 0) {
                this.newTitleTmp = this.getHelperHandler(i).getTitle();
            }
            if (descriptorArray == null) continue;
            this.addResult((AbstractHelperHandler)this.activeHelperHandler.get(i), descriptorArray);
        }
        return this.result;
    }

    void showContentAssistant(String string, int n, String string2) {
        if (this.uiHelper == null) {
            this.uiHelper = new ContentAssistantUI();
        }
        this.uiHelper.show(string, this.container.getUIAccessibility().getEditor(), n, string2, this.result);
    }

    void addResult(AbstractHelperHandler abstractHelperHandler, Descriptor[] descriptorArray) {
        for (int i = 0; i < descriptorArray.length; ++i) {
            this.result.add(descriptorArray[i]);
            if (!(descriptorArray[i] instanceof TagDescriptor)) continue;
            TagDescriptor tagDescriptor = (TagDescriptor)descriptorArray[i];
            for (int j = 0; j < tagDescriptor.getSynonymousTagDescriptorCount(); ++j) {
                this.result.add(i + 1, tagDescriptor.getSynonymousTagDescriptor(j));
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void dump() {
        System.out.println("Dump HelperManager :");
        if (this.handlers == null) {
            System.out.println("No content");
        } else {
            for (int i = 0; i < this.handlers.size(); ++i) {
                System.out.println(this.handlers.get(i));
            }
        }
    }

    public void resetHandlers(ArrayList arrayList, boolean bl) {
        if (!bl || this.handlers == null) {
            this.handlers = arrayList;
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.addHelperHandler((AbstractHelperHandler)arrayList.get(i));
            }
        }
    }

    private void addWithPriority(AbstractHelperHandler abstractHelperHandler) {
        boolean bl = false;
        for (int i = 0; i < this.handlers.size(); ++i) {
            if (((AbstractHelperHandler)this.handlers.get(i)).getPriority() >= abstractHelperHandler.getPriority()) continue;
            bl = true;
            this.handlers.add(i, abstractHelperHandler);
            break;
        }
        if (!bl) {
            this.handlers.add(abstractHelperHandler);
        }
    }

    public void addHelperHandler(AbstractHelperHandler abstractHelperHandler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        if (abstractHelperHandler instanceof AbstractTagHandler) {
            ((AbstractTagHandler)abstractHelperHandler).setNamespace(this.container.getDocumentInfo().getDefaultNamespace());
        }
        if (abstractHelperHandler.getType() == null) {
            this.addWithPriority(abstractHelperHandler);
        } else {
            boolean bl = false;
            for (int i = 0; i < this.handlers.size(); ++i) {
                String string = ((AbstractHelperHandler)this.handlers.get(i)).getType();
                if (string == null || !string.equalsIgnoreCase(abstractHelperHandler.getType())) continue;
                this.handlers.add(i + 1, abstractHelperHandler);
                bl = true;
                break;
            }
            if (!bl) {
                this.addWithPriority(abstractHelperHandler);
            }
        }
    }

    public void removeHelperHandler(AbstractHelperHandler abstractHelperHandler) {
        if (this.handlers != null) {
            this.handlers.remove(abstractHelperHandler);
            abstractHelperHandler.dispose();
        }
    }

    public boolean removeHelperHandler(String string) {
        for (int i = 0; i < this.getHelperHandlerCount(); ++i) {
            AbstractHelperHandler abstractHelperHandler = this.getHelperHandler(i);
            if (!abstractHelperHandler.getName().equalsIgnoreCase(string)) continue;
            this.removeHelperHandler(abstractHelperHandler);
            return true;
        }
        return false;
    }

    public int getHelperHandlerCount() {
        if (this.handlers == null) {
            return 0;
        }
        return this.handlers.size();
    }

    public AbstractHelperHandler getHelperHandler(int n) {
        if (this.handlers == null) {
            return null;
        }
        return (AbstractHelperHandler)this.handlers.get(n);
    }

    public AbstractHelperHandler getHelperHandler(String string) {
        for (int i = 0; i < this.getHelperHandlerCount(); ++i) {
            if (this.getHelperHandler(i).getName() == null || !this.getHelperHandler(i).getName().equalsIgnoreCase(string)) continue;
            return this.getHelperHandler(i);
        }
        return null;
    }

    public void setEnabled(String string, boolean bl) {
        AbstractHelperHandler abstractHelperHandler = this.getHelperHandler(string);
        if (abstractHelperHandler != null) {
            abstractHelperHandler.setEnabled(bl);
        }
    }

    class HelperManagerJob
    extends JobAdapter {
        boolean aynchronousMode = false;

        HelperManagerJob() {
        }

        public void run() {
            boolean bl;
            HelperManager.this.prepareDescriptors(HelperManager.this.currentNode, HelperManager.this.container.getDocument(), HelperManager.this.currentInsertBefore, HelperManager.this.currentOffset, HelperManager.this.currentActivatorString);
            if (HelperManager.this.newTitleTmp == null && HelperManager.this.container.getCurrentElementNode() != null) {
                HelperManager.this.newTitleTmp = HelperManager.this.container.getCurrentElementNode().getNodeContent();
            }
            boolean bl2 = bl = HelperManager.this.result.size() > 0;
            if (bl) {
                HelperManager.this.showContentAssistant(HelperManager.this.newTitleTmp == null ? HelperManager.this.currentTitle : HelperManager.this.newTitleTmp, HelperManager.this.currentOffset, HelperManager.this.currentActivatorString);
            } else if (HelperManager.this.currentActivatorString != null && this.aynchronousMode) {
                HelperManager.this.container.getDocument().insertStringWithoutHelper(HelperManager.this.container.getEditor().getCaretPosition(), HelperManager.this.currentActivatorString, null, true);
            }
        }

        public void dispose() {
            HELPER_WORKING = false;
            HelperManager.this.currentNode = null;
            try {
                HelperManager.this.activeHelperHandler.removeAll(HelperManager.this.activeHelperHandler);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }
}

