/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.handler.schema.w3c;

import com.japisoft.fastparser.ParseException;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.AndCriteria;
import com.japisoft.fastparser.walker.AttributeCriteria;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.xmlpad.helper.handler.schema.AbstractTagHandler;
import com.japisoft.xmlpad.helper.handler.schema.w3c.SchemaToSchemaNode;
import com.japisoft.xmlpad.helper.model.EnumerationDescriptor;
import com.japisoft.xmlpad.helper.model.SchemaLocator;
import com.japisoft.xmlpad.helper.model.SchemaNodable;
import com.japisoft.xmlpad.helper.model.SchemaNode;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import com.japisoft.xmlpad.toolkit.XMLFileData;
import com.japisoft.xmlpad.toolkit.XMLToolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;

public class W3cTagHandler
extends AbstractTagHandler
implements SchemaNodable {
    private String root;
    private SimpleNode node;
    private TreeWalker walker = null;
    private SchemaNode schemaNode = null;

    public W3cTagHandler(String string, SimpleNode simpleNode, String string2) {
        this.root = string;
        this.node = simpleNode;
        ArrayList arrayList = new ArrayList();
        this.resolveIncludeRedefine(simpleNode, string2, arrayList);
        this.walker = new TreeWalker(simpleNode);
    }

    public void dispose() {
        super.dispose();
        this.node = null;
        this.walker = null;
    }

    private void resolveIncludeRedefine(SimpleNode simpleNode, String string, ArrayList arrayList) {
        SimpleNode simpleNode2;
        int n;
        ArrayList<SimpleNode> arrayList2 = new ArrayList<SimpleNode>();
        for (n = 0; n < simpleNode.childCount(); ++n) {
            String string2;
            simpleNode2 = simpleNode.childAt(n);
            if (!simpleNode2.isTag()) continue;
            if (simpleNode2.matchContent("include")) {
                string2 = simpleNode2.getAttribute("schemaLocation");
                if (string2 != null) {
                    if (arrayList.contains(string2)) continue;
                    this.resolveNodeInclude(simpleNode, simpleNode2, string, string2);
                    arrayList.add(string2);
                }
                arrayList2.add(simpleNode2);
                continue;
            }
            if (!simpleNode2.matchContent("redefine")) continue;
            string2 = simpleNode2.getAttribute("schemaLocation");
            if (string2 != null) {
                if (arrayList.contains(string2)) continue;
                this.resolveNodeRedefine(simpleNode, simpleNode2, string, string2);
                arrayList.add(string2);
            }
            arrayList2.add(simpleNode2);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            simpleNode2 = (SimpleNode)arrayList2.get(n);
            simpleNode.removeChildNode(simpleNode2);
        }
    }

    private void resolveNodeRedefine(SimpleNode simpleNode, SimpleNode simpleNode2, String string, String string2) {
        block9: {
            InputStream inputStream = null;
            SchemaLocator schemaLocator = new SchemaLocator(string, string2);
            try {
                inputStream = schemaLocator.getInputStream();
                XMLFileData xMLFileData = XMLToolkit.getContentFromInputStream(inputStream, null);
                if (inputStream == null) break block9;
                Parser parser = new Parser();
                parser.setContent(xMLFileData.getContent().toCharArray());
                try {
                    parser.parse();
                    if (parser.getDocument().getRoot() != null) {
                        int n;
                        SimpleNode simpleNode3 = (SimpleNode)parser.getDocument().getRoot();
                        for (n = 0; n < simpleNode3.childCount(); ++n) {
                            SimpleNode simpleNode4 = simpleNode3.childAt(n);
                            String string3 = simpleNode4.getAttribute("name");
                            if (string3 != null) {
                                boolean bl = false;
                                for (int i = 0; i < simpleNode2.childCount(); ++i) {
                                    String string4 = simpleNode2.childAt(i).getAttribute("name");
                                    if (!string3.equals(string4)) continue;
                                    bl = true;
                                    break;
                                }
                                if (bl) continue;
                                simpleNode.addChildNode(simpleNode4);
                                continue;
                            }
                            simpleNode.addChildNode(simpleNode4);
                        }
                        for (n = 0; n < simpleNode2.childCount(); ++n) {
                            simpleNode.addChildNode(simpleNode2.childAt(n));
                        }
                    }
                }
                catch (ParseException parseException) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void resolveNodeInclude(SimpleNode simpleNode, SimpleNode simpleNode2, String string, String string2) {
        block6: {
            InputStream inputStream = null;
            SchemaLocator schemaLocator = new SchemaLocator(string, string2);
            try {
                inputStream = schemaLocator.getInputStream();
                if (inputStream == null) break block6;
                Parser parser = new Parser();
                XMLFileData xMLFileData = XMLToolkit.getContentFromInputStream(inputStream, null);
                try {
                    parser.setContent(xMLFileData.getContent().toCharArray());
                    parser.parse();
                    if (parser.getDocument().getRoot() != null) {
                        SimpleNode simpleNode3 = (SimpleNode)parser.getDocument().getRoot();
                        for (int i = 0; i < simpleNode3.childCount(); ++i) {
                            simpleNode.addChildNode(simpleNode3.childAt(i));
                        }
                    }
                }
                catch (ParseException parseException) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public TagDescriptor getTag(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = this.getElementDef(simpleNode);
        if (simpleNode2 == null) {
            return null;
        }
        SchemaToSchemaNode schemaToSchemaNode = new SchemaToSchemaNode();
        schemaToSchemaNode.allattributeMode = true;
        SchemaNode schemaNode = new SchemaNode(0);
        schemaToSchemaNode.processElement(simpleNode2, schemaNode, true);
        return schemaNode.element;
    }

    public SchemaNode getSchemaNode() {
        return this.schemaNode;
    }

    private SimpleNode getElementDef(SimpleNode simpleNode) {
        SimpleNode simpleNode2 = this.walker.getOneNodeByCriteria(new AndCriteria(new NodeNameCriteria("element"), new AttributeCriteria("name", simpleNode.getContent())), true);
        return simpleNode2;
    }

    private SimpleNode getElementTypeDef(SimpleNode simpleNode) {
        if (simpleNode.hasAttribute("type")) {
            String string = simpleNode.getAttribute("type");
            String string2 = simpleNode.getNameSpacePrefix();
            if (string2 != null && string.startsWith(string2 + ":")) {
                return null;
            }
            for (int i = 0; i < this.node.getViewChildCount(); ++i) {
                SimpleNode simpleNode2 = (SimpleNode)this.node.getViewChildAt(i);
                if (!simpleNode2.matchContent("simpleType") && !simpleNode2.matchContent("complexType") || !string.equals(simpleNode2.getAttribute("name"))) continue;
                return simpleNode2;
            }
        } else {
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                SimpleNode simpleNode3 = (SimpleNode)simpleNode.getViewChildAt(i);
                if (!simpleNode3.matchContent("simpleType") && !simpleNode3.matchContent("complexType")) continue;
                return simpleNode3;
            }
        }
        return null;
    }

    protected void notifyLocation() {
        this.schemaNode = null;
        if (this.currentDocumentNode == null) {
            return;
        }
        SchemaToSchemaNode schemaToSchemaNode = new SchemaToSchemaNode();
        SimpleNode simpleNode = this.getElementDef(this.currentDocumentNode);
        if (simpleNode != null) {
            TreeWalker treeWalker;
            Enumeration enumeration;
            SimpleNode simpleNode2;
            boolean bl = false;
            if (this.isCtrlSpaceActivator() && (simpleNode2 = this.getElementTypeDef(simpleNode)) != null && simpleNode2.matchContent("simpleType") && (enumeration = (treeWalker = new TreeWalker(simpleNode2)).getNodeByCriteria(new NodeNameCriteria("enumeration"), true)) != null) {
                while (enumeration.hasMoreElements()) {
                    bl = true;
                    SimpleNode simpleNode3 = (SimpleNode)enumeration.nextElement();
                    String string = simpleNode3.getAttribute("value");
                    if (string == null) continue;
                    EnumerationDescriptor enumerationDescriptor = new EnumerationDescriptor(string);
                    this.addEnumerationDescriptor(enumerationDescriptor);
                }
            }
            if (!bl) {
                this.schemaNode = schemaToSchemaNode.getSchemaNode(simpleNode);
            }
        }
    }
}

