/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.nodeeditor;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.dialog.DialogManager;
import com.japisoft.xmlpad.nodeeditor.Editor;
import com.japisoft.xmlpad.nodeeditor.EditorContext;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DefaultEditor
implements Editor {
    public boolean accept(SimpleNode simpleNode) {
        return simpleNode.isText();
    }

    public void edit(EditorContext editorContext) {
        XMLContainer xMLContainer = editorContext.getXMLContainer();
        TextPane textPane = new TextPane();
        textPane.setText(editorContext.getEditedText());
        textPane.setPreferredSize(new Dimension(300, 300));
        if (DialogManager.showDialog(SwingUtilities.getWindowAncestor(xMLContainer.getView()), "Edit", "Update", "Edit the current selected text node", null, textPane) == 0) {
            editorContext.setResult(textPane.getText());
        }
    }

    class TextPane
    extends JPanel {
        private JTextArea text;

        public TextPane() {
            this.init();
        }

        void init() {
            this.setLayout(new BorderLayout());
            this.text = new JTextArea();
            this.add(new JScrollPane(this.text));
        }

        public void addNotify() {
            super.addNotify();
            this.text.requestFocus();
        }

        public void setText(String string) {
            string = string.replaceAll("&lt;", "<");
            string = string.replaceAll("&gt;", ">");
            this.text.setText(string);
        }

        public String getText() {
            String string = this.text.getText();
            string = string.replaceAll("<", "&lt;");
            string = string.replaceAll(">", "&gt;");
            return string;
        }
    }
}

