/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.tree.parser;

import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.swing.SwingNodeFactory;
import com.japisoft.fastparser.tools.XMLToolkit;
import com.japisoft.framework.job.KnownJob;
import com.japisoft.framework.job.SwingEventSynchro;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.tree.TreeListeners;
import com.japisoft.xmlpad.tree.parser.ParsingErrorListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ParsingJob
implements KnownJob,
SwingEventSynchro {
    private Parser p;
    private boolean running = false;
    private ParsingErrorListener parsingErrorListener;
    private XMLContainer container;
    private TreeListeners listeners;
    private boolean lockedLocation = false;
    Document d = null;

    public ParsingJob(XMLContainer xMLContainer, TreeListeners treeListeners) {
        if (xMLContainer == null) {
            throw new NullPointerException("The container cannot be null !");
        }
        this.container = xMLContainer;
        this.parsingErrorListener = new ParsingErrorListener(xMLContainer.getErrorManager());
        this.listeners = treeListeners;
    }

    private XMLEditor getEditor() {
        return this.container.getUIAccessibility().getEditor();
    }

    private JTree getTree() {
        return this.listeners.getTree();
    }

    public void dispose() {
        this.d = null;
        if (this.p != null && !this.p.isInterrupted() && this.getEditor() != null) {
            this.getEditor().setEnabledXPathLocation(true);
        }
    }

    public void disposeAll() {
        this.dispose();
        this.parsingErrorListener.dispose();
        this.parsingErrorListener = null;
        this.container = null;
        this.listeners = null;
    }

    public String getName() {
        return "parsing";
    }

    public boolean isLocationLocked() {
        return this.lockedLocation;
    }

    public void stopIt() {
        if (this.p != null && this.running) {
            this.p.interruptParsing();
        }
        this.lockedLocation = false;
    }

    public Object getSource() {
        return this;
    }

    public boolean isAlone() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean preRun() {
        block10: {
            this.d = null;
            this.lockedLocation = true;
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.running = true;
                this.p = this.container.getRootNode() != null ? new Parser(this.container.getRootNode().getDocument()) : new Parser();
                this.p.setFlatView(true);
                this.p.setBackgroundMode(true);
                this.p.setParsingMode(0);
                this.p.setErrorSignal(this.parsingErrorListener);
                this.p.setNodeFactory(SwingNodeFactory.getFactory());
                String string = this.getEditor().getText();
                this.p.setContent(string.toCharArray());
                if (!this.p.isInterrupted()) {
                    this.p.parse();
                }
                if (this.p.hasError() || this.p.isInterrupted()) break block10;
                this.d = this.p.getDocument();
                this.container.getErrorManager().notifyNoError(true);
                if (this.getTree() != null && (this.d == null || this.d.getRoot() == null)) {
                    this.getTree().setModel(new DefaultTreeModel(null));
                    boolean bl = false;
                    this.container.getErrorManager().stopErrorProcessing();
                    this.lockedLocation = false;
                    this.running = false;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                if (!"true".equals(System.getProperty("xmlpad.debug"))) return false;
                throwable.printStackTrace();
                return false;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            {
                boolean bl = true;
                this.container.getErrorManager().stopErrorProcessing();
                this.lockedLocation = false;
                this.running = false;
                return bl;
            }
        }
        return false;
    }

    public String getErrorMessage() {
        return null;
    }

    public void run() {
        SimpleNode simpleNode;
        boolean bl = false;
        if (this.getTree() != null && !this.p.isInterrupted()) {
            this.getTree().setModel(new DefaultTreeModel((TreeNode)((Object)this.d.getRoot())));
        }
        TreePath treePath = null;
        if (this.getTree() != null) {
            treePath = this.getTree().getSelectionPath();
        }
        String string = null;
        if (treePath != null) {
            simpleNode = (SimpleNode)treePath.getLastPathComponent();
            string = simpleNode.getXPathLocation();
        }
        this.container.setLastNodeParsed((SimpleNode)this.d.getRoot());
        if (this.d.getRoot() != null) {
            if (string != null && (treePath = XMLToolkit.getTreePath(simpleNode = ((SimpleNode)this.d.getRoot()).getNodeForXPathLocation(string, true))) != null) {
                this.getTree().setSelectionPath(treePath);
            }
            this.lockedLocation = false;
            bl = true;
        } else if (this.getTree() == null || ((XMLDocument)this.getEditor().getDocument()).forceLocation()) {
            this.lockedLocation = false;
            bl = true;
        }
        if (bl && this.getEditor() != null) {
            this.getEditor().setEnabledXPathLocation(true);
            this.getEditor().notifyCurrentLocation();
        }
    }
}

