/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath;

import com.japisoft.xpath.Navigator;
import com.japisoft.xpath.NodeSet;
import com.japisoft.xpath.XPathKit;
import com.japisoft.xpath.function.Lib;
import java.util.Enumeration;
import java.util.Hashtable;

public final class XPathContext {
    private XPathKit kit;
    private Object refNode;
    private boolean cache;
    private Hashtable htCache = null;
    private NodeSet contextNodeSet;
    private int position;
    private Hashtable htVariable;
    private Hashtable htNamespace;
    private Lib lib;
    private Navigator nav;
    private boolean predicateMode = false;

    private XPathContext(XPathKit xPathKit) {
        this.kit = xPathKit;
        this.setLibrary(xPathKit.getLibrary());
        this.setNavigator(xPathKit.getNavigator());
    }

    public XPathContext(Object object, XPathKit xPathKit) {
        this(xPathKit);
        this.setContextNode(object);
        this.refNode = object;
    }

    public XPathContext clone(Object object) {
        XPathContext xPathContext = new XPathContext(object, this.kit);
        xPathContext.htNamespace = this.htNamespace;
        xPathContext.htVariable = this.htVariable;
        return xPathContext;
    }

    public void setCache(boolean bl) {
        this.cache = bl;
    }

    public boolean hasCache() {
        return this.cache;
    }

    public void setNavigatorCacheContent(Hashtable hashtable) {
        this.htCache = hashtable;
    }

    public NodeSet getNavigatorCacheValue(Object object, String string, String string2, String string3, String string4) {
        if (this.htCache == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(object.hashCode()).append(string).append(string2).append(string3).append(string4);
        return (NodeSet)this.htCache.get(stringBuffer.toString());
    }

    public void setNavigatorCacheValue(Object object, String string, String string2, String string3, String string4, NodeSet nodeSet) {
        if (this.htCache == null) {
            this.htCache = new Hashtable();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(object.hashCode()).append(string).append(string2).append(string3).append(string4);
        this.htCache.put(stringBuffer.toString(), nodeSet);
    }

    public void setContextNode(Object object) {
        if (object != null) {
            this.setContextNodeSet(new NodeSet(object));
        }
    }

    public void setContextNodeSet(NodeSet nodeSet) {
        this.contextNodeSet = nodeSet;
        this.setContextPosition(0);
    }

    public NodeSet getContextNodeSet() {
        return this.contextNodeSet;
    }

    public void setContextPosition(int n) {
        this.position = n;
    }

    public int getContextPosition() {
        return this.position;
    }

    public Object getNodeFromContext() {
        NodeSet nodeSet = this.getContextNodeSet();
        if (nodeSet.size() > this.getContextPosition()) {
            return nodeSet.elementAt(this.getContextPosition());
        }
        return null;
    }

    public Object getFirstNodeFromContext() {
        NodeSet nodeSet = this.getContextNodeSet();
        if (nodeSet == null || nodeSet.size() == 0) {
            return null;
        }
        return nodeSet.elementAt(0);
    }

    public int getContextSize() {
        return this.getContextNodeSet().size();
    }

    public void setVariable(String string, Object object) {
        if (this.htVariable == null) {
            this.htVariable = new Hashtable();
        }
        this.htVariable.put(string, object);
    }

    public void removeVariable(String string) {
        if (this.htVariable != null) {
            this.htVariable.remove(string);
        }
    }

    void setNamespaceDeclarationModel(Hashtable hashtable) {
        this.htNamespace = hashtable;
    }

    public void addNamespace(String string, String string2) {
        if (this.htNamespace == null) {
            this.htNamespace = new Hashtable();
        }
        this.htNamespace.put(string, string2);
    }

    public void removeNamespace(String string) {
        if (this.htNamespace != null) {
            this.htNamespace.remove(string);
        }
    }

    public boolean hasNamespaceDeclaration(String string) {
        if (this.htNamespace == null) {
            return false;
        }
        return this.htNamespace.containsKey(string);
    }

    public Object getVariable(String string) {
        if (this.htVariable == null) {
            return null;
        }
        return this.htVariable.get(string);
    }

    public Enumeration variablesEnum() {
        if (this.htVariable != null) {
            return this.htVariable.keys();
        }
        return null;
    }

    public String getNamespaceURI(String string) {
        return (String)this.htNamespace.get(string);
    }

    public boolean hasVariable(String string) {
        if (this.htVariable == null) {
            return false;
        }
        return this.htVariable.containsKey(string);
    }

    void setVariableModel(Hashtable hashtable) {
        this.htVariable = hashtable;
    }

    public String getStringValue(Object object) {
        return this.kit.getStringValue(object);
    }

    public Double convertNodeSetToDouble(NodeSet nodeSet) {
        try {
            String string = "";
            for (int i = 0; i < nodeSet.size(); ++i) {
                Object object = nodeSet.get(i);
                string = string + this.getStringValue(object);
            }
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(Double.NaN);
        }
    }

    public Object getNodeForId(String string) {
        return this.kit.getNodeForId(this.refNode, string);
    }

    public NodeSet getFullDocumentNodes(Object object) {
        return this.getNavigator().getNodes(object, "descendant", "node", "*", null, false);
    }

    public String getLocalName(Object object) {
        return this.kit.getLocalName(object);
    }

    public String getNamespaceURI(Object object) {
        return this.kit.getNamespaceURI(object);
    }

    public String getName(Object object) {
        return this.kit.getName(object);
    }

    public String getLang(Object object) {
        return this.kit.getLang(object);
    }

    public void setLibrary(Lib lib) {
        this.lib = lib;
    }

    public Lib getLibrary() {
        return this.lib;
    }

    public void setNavigator(Navigator navigator) {
        this.nav = navigator;
    }

    public Navigator getNavigator() {
        return this.nav;
    }

    public void setPredicateMode(boolean bl) {
        this.predicateMode = bl;
    }

    public boolean isPredicateMode() {
        return this.predicateMode;
    }
}

