/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath.navigator;

import com.japisoft.xpath.Navigator;
import com.japisoft.xpath.NodeSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMNavigator
implements Navigator {
    static NodeMatcher nodeMatcher = new StandardNodeMatcher();
    private static Hashtable htResolver = new Hashtable();

    public void setIgnoreCaseMode(boolean bl) {
        nodeMatcher = !bl ? new StandardNodeMatcher() : new IgnoreCaseNodeMatcher();
    }

    private static void setAllDescendant(boolean bl, boolean bl2, String string, int n, String string2, Node node, NodeSet nodeSet) {
        if (bl) {
            if (bl2 && nodeMatcher.matchNode(node, n, string2)) {
                nodeSet.add(node);
            } else if (nodeMatcher.matchNode(node, string, n, string2)) {
                nodeSet.add(node);
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (bl2 && nodeMatcher.matchNode(node2, n, string2)) {
                nodeSet.add(node2);
            } else if (nodeMatcher.matchNode(node2, string, n, string2)) {
                nodeSet.add(node2);
            }
            if (!node2.hasChildNodes()) continue;
            DOMNavigator.setAllDescendant(false, bl2, string, n, string2, node2, nodeSet);
        }
    }

    private static int getIndexOfNode(Node node, Node node2) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) != node2) continue;
            n = i;
            break;
        }
        return n;
    }

    public Object getRoot(Object object) {
        Node node = (Node)object;
        if (node.getParentNode() == null || node.getParentNode() instanceof Document) {
            return node;
        }
        return node.getOwnerDocument().getDocumentElement();
    }

    public Object getDocumentRoot(Object object) {
        if (object == null) {
            throw new RuntimeException("No reference node");
        }
        return ((Node)object).getOwnerDocument();
    }

    public NodeSet getNodes(Object object, String string, String string2, String string3, String string4, boolean bl) {
        Node node = (Node)object;
        NodeSet nodeSet = new NodeSet();
        int n = 1;
        if ("text".equals(string2)) {
            n = 3;
        } else if ("comment".equals(string2)) {
            n = 8;
        } else if ("processing-instruction".equals(string2)) {
            n = 7;
        }
        boolean bl2 = "*".equals(string3);
        AxisResolver axisResolver = (AxisResolver)htResolver.get(string);
        if (axisResolver == null) {
            throw new RuntimeException("Unknown axis " + string);
        }
        axisResolver.resolve(nodeSet, node, string3, n, bl2, string4, bl);
        return nodeSet;
    }

    static {
        htResolver.put("ancestor", new AncestorResolver());
        htResolver.put("ancestor-or-self", new AncestorOrSelfResolver());
        htResolver.put("attribute", new AttributeResolver());
        htResolver.put("child", new ChildResolver());
        htResolver.put("descendant", new DescendantResolver());
        htResolver.put("descendant-or-self", new DescendantOrSelfResolver());
        htResolver.put("following", new FollowingResolver());
        htResolver.put("following-sibling", new FollowingSiblingResolver());
        htResolver.put("parent", new ParentResolver());
        htResolver.put("preceding", new PrecedingResolver());
        htResolver.put("preceding-sibling", new PrecedingSiblingResolver());
        htResolver.put("self", new SelfResolver());
    }

    static class SelfResolver
    implements AxisResolver {
        SelfResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            if (bl) {
                if (nodeMatcher.matchNode(node, n, string2)) {
                    nodeSet.addNode(node);
                }
            } else if (nodeMatcher.matchNode(node, string, n, string2)) {
                nodeSet.addNode(node);
            }
        }
    }

    static class PrecedingSiblingResolver
    implements AxisResolver {
        PrecedingSiblingResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            Node node2 = node.getParentNode();
            if (node2 != null) {
                int n2 = DOMNavigator.getIndexOfNode(node2, node);
                NodeList nodeList = node2.getChildNodes();
                for (int i = 0; i < n2; ++i) {
                    Node node3 = nodeList.item(i);
                    if (bl && nodeMatcher.matchNode(node3, 1, string2)) {
                        nodeSet.addNode(node3);
                        continue;
                    }
                    if (!nodeMatcher.matchNode(node3, string, n, string2)) continue;
                    nodeSet.addNode(node3);
                }
            }
        }
    }

    static class PrecedingResolver
    implements AxisResolver {
        PrecedingResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            Node node2 = node.getParentNode();
            if (node2 != null) {
                int n2 = DOMNavigator.getIndexOfNode(node2, node);
                NodeList nodeList = node2.getChildNodes();
                for (int i = 0; i < n2; ++i) {
                    DOMNavigator.setAllDescendant(true, bl, string, n, string2, nodeList.item(i), nodeSet);
                }
            }
        }
    }

    static class ParentResolver
    implements AxisResolver {
        ParentResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            if (node.getParentNode() != null) {
                nodeSet.add(node.getParentNode());
            }
        }
    }

    static class FollowingSiblingResolver
    implements AxisResolver {
        FollowingSiblingResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            Node node2 = node.getParentNode();
            if (node2 != null) {
                int n2 = DOMNavigator.getIndexOfNode(node2, node);
                NodeList nodeList = node2.getChildNodes();
                for (int i = n2 + 1; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    if (bl && nodeMatcher.matchNode(node3, 1, string2)) {
                        nodeSet.addNode(node3);
                        continue;
                    }
                    if (!nodeMatcher.matchNode(node3, string, n, string2)) continue;
                    nodeSet.addNode(node3);
                }
            }
        }
    }

    static class FollowingResolver
    implements AxisResolver {
        FollowingResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            Node node2 = node.getParentNode();
            if (node2 != null) {
                int n2 = DOMNavigator.getIndexOfNode(node2, node);
                NodeList nodeList = node2.getChildNodes();
                for (int i = n2 + 1; i < nodeList.getLength(); ++i) {
                    DOMNavigator.setAllDescendant(true, bl, string, n, string2, nodeList.item(i), nodeSet);
                }
            }
        }
    }

    static class DescendantOrSelfResolver
    implements AxisResolver {
        DescendantOrSelfResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            if (bl2) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null && node.getNodeType() == 1) {
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        Node node2 = namedNodeMap.item(i);
                        if (bl) {
                            nodeSet.add(node2);
                            continue;
                        }
                        if (!node2.getNodeName().equals(string)) continue;
                        nodeSet.add(node2);
                    }
                }
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    if (node3.getNodeType() != 1) continue;
                    this.resolve(nodeSet, nodeList.item(i), string, n, bl, string2, bl2);
                }
            } else {
                DOMNavigator.setAllDescendant(true, bl, string, n, string2, node, nodeSet);
            }
        }
    }

    static class DescendantResolver
    implements AxisResolver {
        DescendantResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            DOMNavigator.setAllDescendant(false, bl, string, n, string2, node, nodeSet);
        }
    }

    static class ChildResolver
    implements AxisResolver {
        ChildResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            Node node2 = node;
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node2 = nodeList.item(i);
                if (bl && nodeMatcher.matchNode(node2, -1, string2)) {
                    nodeSet.addNode(node2);
                    continue;
                }
                if (!nodeMatcher.matchNode(node2, string, n, string2)) continue;
                nodeSet.addNode(node2);
            }
        }
    }

    static class AttributeResolver
    implements AxisResolver {
        AttributeResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    if (bl && nodeMatcher.matchNode(node2, string2)) {
                        nodeSet.addNode(node2);
                        continue;
                    }
                    if (!nodeMatcher.matchNode(node2, string, string2)) continue;
                    nodeSet.addNode(node2);
                }
            }
        }
    }

    static class AncestorOrSelfResolver
    implements AxisResolver {
        AncestorOrSelfResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            Node node2 = node;
            while (!(node2 instanceof Document)) {
                if (bl && nodeMatcher.matchNode(node2, -1, string2)) {
                    nodeSet.addNode(node2);
                } else if (nodeMatcher.matchNode(node2, string, n, string2)) {
                    nodeSet.addNode(node2);
                }
                node2 = node2.getParentNode();
            }
        }
    }

    static class AncestorResolver
    implements AxisResolver {
        AncestorResolver() {
        }

        public void resolve(NodeSet nodeSet, Node node, String string, int n, boolean bl, String string2, boolean bl2) {
            for (Node node2 = node.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
                if (bl && nodeMatcher.matchNode(node2, -1, string2)) {
                    nodeSet.addNode(node2);
                    continue;
                }
                if (!nodeMatcher.matchNode(node2, string, n, string2)) continue;
                nodeSet.addNode(node2);
            }
        }
    }

    static interface AxisResolver {
        public void resolve(NodeSet var1, Node var2, String var3, int var4, boolean var5, String var6, boolean var7);
    }

    static final class IgnoreCaseNodeMatcher
    implements NodeMatcher {
        IgnoreCaseNodeMatcher() {
        }

        public boolean matchNode(Node node, int n, String string) {
            return node.getNodeType() == n && (string == null || string.equalsIgnoreCase(node.getNamespaceURI()));
        }

        public boolean matchNode(Node node, String string, int n, String string2) {
            boolean bl;
            boolean bl2 = bl = node.getNodeType() == n && (string2 == null || string2.equalsIgnoreCase(node.getNamespaceURI()));
            if (bl) {
                String string3 = node.getLocalName();
                if (string3 == null) {
                    string3 = node.getNodeName();
                }
                return string.equalsIgnoreCase(string3);
            }
            return false;
        }

        public boolean matchNode(Node node, String string) {
            if (string == null) {
                return true;
            }
            return string.equalsIgnoreCase(node.getNamespaceURI());
        }

        public boolean matchNode(Node node, String string, String string2) {
            String string3 = node.getLocalName();
            if (string3 == null) {
                string3 = node.getNodeName();
            }
            if (string2 == null) {
                return string.equalsIgnoreCase(string3);
            }
            return string2.equalsIgnoreCase(node.getNamespaceURI()) && string.equalsIgnoreCase(string3);
        }
    }

    static final class StandardNodeMatcher
    implements NodeMatcher {
        StandardNodeMatcher() {
        }

        public boolean matchNode(Node node, int n, String string) {
            return !(node.getNodeType() != n && n != -1 || string != null && !string.equals(node.getNamespaceURI()));
        }

        public boolean matchNode(Node node, String string, int n, String string2) {
            boolean bl;
            boolean bl2 = bl = node.getNodeType() == n && (string2 == null || string2.equals(node.getNamespaceURI()));
            if (bl) {
                String string3 = node.getLocalName();
                if (string3 == null) {
                    string3 = node.getNodeName();
                }
                return string.equals(string3);
            }
            return false;
        }

        public boolean matchNode(Node node, String string) {
            if (string == null) {
                return true;
            }
            return string.equals(node.getNamespaceURI());
        }

        public boolean matchNode(Node node, String string, String string2) {
            String string3 = node.getLocalName();
            if (string3 == null) {
                string3 = node.getNodeName();
            }
            if (string2 == null) {
                return string.equals(string3);
            }
            return string2.equals(node.getNamespaceURI()) && string.equals(string3);
        }
    }

    static interface NodeMatcher {
        public boolean matchNode(Node var1, int var2, String var3);

        public boolean matchNode(Node var1, String var2, int var3, String var4);

        public boolean matchNode(Node var1, String var2);

        public boolean matchNode(Node var1, String var2, String var3);
    }
}

