/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath.navigator;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xpath.Navigator;
import com.japisoft.xpath.NodeSet;
import java.util.Enumeration;
import java.util.Hashtable;

public final class FastParserNavigator
implements Navigator {
    private static Hashtable htResolver = new Hashtable();

    private static boolean matchNode(SimpleNode simpleNode, int n, String string) {
        return simpleNode.getType() == n && (string == null || string.equals(simpleNode.getNameSpaceURI()));
    }

    private static boolean matchNode(SimpleNode simpleNode, String string, int n, String string2) {
        boolean bl;
        boolean bl2 = bl = simpleNode.getType() == n && (string2 == null || string2.equals(simpleNode.getNameSpaceURI()));
        if (bl) {
            return string.equals(simpleNode.getContent());
        }
        return false;
    }

    private static void setAllDescendant(boolean bl, boolean bl2, String string, int n, String string2, SimpleNode simpleNode, NodeSet nodeSet) {
        if (bl) {
            if (bl2 && FastParserNavigator.matchNode(simpleNode, n, string2)) {
                nodeSet.add(simpleNode);
            } else if (FastParserNavigator.matchNode(simpleNode, string, n, string2)) {
                nodeSet.add(simpleNode);
            }
        }
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            SimpleNode simpleNode2 = simpleNode.childAt(i);
            if (bl2 && FastParserNavigator.matchNode(simpleNode2, n, string2)) {
                nodeSet.add(simpleNode2);
            } else if (FastParserNavigator.matchNode(simpleNode2, string, n, string2)) {
                nodeSet.add(simpleNode2);
            }
            if (simpleNode2.childCount() <= 0) continue;
            FastParserNavigator.setAllDescendant(false, bl2, string, n, string2, simpleNode2, nodeSet);
        }
    }

    public Object getRoot(Object object) {
        SimpleNode simpleNode = (SimpleNode)object;
        if (simpleNode.isRoot()) {
            return simpleNode;
        }
        return simpleNode.getDocument().getRoot();
    }

    public Object getDocumentRoot(Object object) {
        SimpleNode simpleNode = (SimpleNode)this.getRoot(object);
        SimpleNode simpleNode2 = new SimpleNode(1, "/");
        simpleNode2.addChildNode(simpleNode);
        simpleNode2.setSimpleParent(null);
        simpleNode.setSimpleParent(null);
        return simpleNode2;
    }

    public NodeSet getNodes(Object object, String string, String string2, String string3, String string4, boolean bl) {
        SimpleNode simpleNode = (SimpleNode)object;
        NodeSet nodeSet = new NodeSet();
        int n = 1;
        if ("text".equals(string2)) {
            n = 0;
        } else if ("comment".equals(string2)) {
            n = 2;
        } else if ("processing-instruction".equals(string2)) {
            n = 4;
        }
        boolean bl2 = "*".equals(string3);
        AxisResolver axisResolver = (AxisResolver)htResolver.get(string);
        if (axisResolver == null) {
            throw new RuntimeException("Unknown axis " + string);
        }
        axisResolver.resolve(nodeSet, simpleNode, string3, n, bl2, string4);
        return nodeSet;
    }

    static {
        htResolver.put("ancestor", new AncestorResolver());
        htResolver.put("ancestor-or-self", new AncestorOrSelfResolver());
        htResolver.put("attribute", new AttributeResolver());
        htResolver.put("child", new ChildResolver());
        htResolver.put("descendant", new DescendantResolver());
        htResolver.put("descendant-or-self", new DescendantOrSelfResolver());
        htResolver.put("following", new FollowingResolver());
        htResolver.put("following-sibling", new FollowingSiblingResolver());
        htResolver.put("parent", new ParentResolver());
        htResolver.put("preceding", new PrecedingResolver());
        htResolver.put("preceding-sibling", new PrecedingSiblingResolver());
        htResolver.put("self", new SelfResolver());
    }

    static class SelfResolver
    implements AxisResolver {
        SelfResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            if (bl) {
                if (FastParserNavigator.matchNode(simpleNode, n, string2)) {
                    nodeSet.addNode(simpleNode);
                }
            } else if (FastParserNavigator.matchNode(simpleNode, string, n, string2)) {
                nodeSet.addNode(simpleNode);
            }
        }
    }

    static class PrecedingSiblingResolver
    implements AxisResolver {
        PrecedingSiblingResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            SimpleNode simpleNode2 = simpleNode.getSimpleParent();
            if (simpleNode2 != null) {
                int n2 = simpleNode2.childNodeIndex(simpleNode);
                for (int i = 0; i < n2; ++i) {
                    SimpleNode simpleNode3 = simpleNode2.childAt(i);
                    if (bl && FastParserNavigator.matchNode(simpleNode3, n, string2)) {
                        nodeSet.addNode(simpleNode3);
                        continue;
                    }
                    if (!FastParserNavigator.matchNode(simpleNode3, string, n, string2)) continue;
                    nodeSet.addNode(simpleNode3);
                }
            }
        }
    }

    static class PrecedingResolver
    implements AxisResolver {
        PrecedingResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            SimpleNode simpleNode2 = simpleNode.getSimpleParent();
            if (simpleNode2 != null) {
                int n2 = simpleNode2.childNodeIndex(simpleNode);
                for (int i = 0; i < n2; ++i) {
                    FastParserNavigator.setAllDescendant(true, bl, string, n, string2, simpleNode2.childAt(i), nodeSet);
                }
            }
        }
    }

    static class ParentResolver
    implements AxisResolver {
        ParentResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            if (simpleNode.getSimpleParent() != null) {
                nodeSet.add(simpleNode.getSimpleParent());
            }
        }
    }

    static class FollowingSiblingResolver
    implements AxisResolver {
        FollowingSiblingResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            SimpleNode simpleNode2 = simpleNode.getSimpleParent();
            if (simpleNode2 != null) {
                int n2 = simpleNode2.childNodeIndex(simpleNode);
                for (int i = n2 + 1; i < simpleNode2.childCount(); ++i) {
                    SimpleNode simpleNode3 = simpleNode2.childAt(i);
                    if (bl && FastParserNavigator.matchNode(simpleNode3, n, string2)) {
                        nodeSet.addNode(simpleNode3);
                        continue;
                    }
                    if (!FastParserNavigator.matchNode(simpleNode3, string, n, string2)) continue;
                    nodeSet.addNode(simpleNode3);
                }
            }
        }
    }

    static class FollowingResolver
    implements AxisResolver {
        FollowingResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            SimpleNode simpleNode2 = simpleNode.getSimpleParent();
            if (simpleNode2 != null) {
                int n2 = simpleNode2.childNodeIndex(simpleNode);
                for (int i = n2 + 1; i < simpleNode2.childCount(); ++i) {
                    FastParserNavigator.setAllDescendant(true, bl, string, n, string2, simpleNode2.childAt(i), nodeSet);
                }
            }
        }
    }

    static class DescendantOrSelfResolver
    implements AxisResolver {
        DescendantOrSelfResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            FastParserNavigator.setAllDescendant(true, bl, string, n, string2, simpleNode, nodeSet);
        }
    }

    static class DescendantResolver
    implements AxisResolver {
        DescendantResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            FastParserNavigator.setAllDescendant(false, bl, string, n, string2, simpleNode, nodeSet);
        }
    }

    static class ChildResolver
    implements AxisResolver {
        ChildResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            SimpleNode simpleNode2 = simpleNode;
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                simpleNode2 = simpleNode.childAt(i);
                if (bl && FastParserNavigator.matchNode(simpleNode2, n, string2)) {
                    nodeSet.addNode(simpleNode2);
                    continue;
                }
                if (!FastParserNavigator.matchNode(simpleNode2, string, n, string2)) continue;
                nodeSet.addNode(simpleNode2);
            }
        }
    }

    static class AttributeResolver
    implements AxisResolver {
        AttributeResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            SimpleNode simpleNode2 = simpleNode;
            Enumeration enumeration = simpleNode.getViewAttributes();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (bl) {
                        nodeSet.addNode(new SimpleNode(simpleNode, 3, string3));
                        continue;
                    }
                    if (!string.equals(string3)) continue;
                    nodeSet.addNode(new SimpleNode(simpleNode, 3, string3));
                }
            }
        }
    }

    static class AncestorOrSelfResolver
    implements AxisResolver {
        AncestorOrSelfResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            for (SimpleNode simpleNode2 = simpleNode; simpleNode2 != null; simpleNode2 = simpleNode2.getSimpleParent()) {
                if (bl && FastParserNavigator.matchNode(simpleNode2, n, string2)) {
                    nodeSet.addNode(simpleNode2);
                    continue;
                }
                if (!FastParserNavigator.matchNode(simpleNode2, string, n, string2)) continue;
                nodeSet.addNode(simpleNode2);
            }
        }
    }

    static class AncestorResolver
    implements AxisResolver {
        AncestorResolver() {
        }

        public void resolve(NodeSet nodeSet, SimpleNode simpleNode, String string, int n, boolean bl, String string2) {
            for (SimpleNode simpleNode2 = simpleNode.getSimpleParent(); simpleNode2 != null; simpleNode2 = simpleNode2.getSimpleParent()) {
                if (bl && FastParserNavigator.matchNode(simpleNode2, n, string2)) {
                    nodeSet.addNode(simpleNode2);
                    continue;
                }
                if (!FastParserNavigator.matchNode(simpleNode2, string, n, string2)) continue;
                nodeSet.addNode(simpleNode2);
            }
        }
    }

    static interface AxisResolver {
        public void resolve(NodeSet var1, SimpleNode var2, String var3, int var4, boolean var5, String var6);
    }
}

