/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.bzip2.CBZip2InputStream;
import org.apache.commons.vfs.provider.bzip2.CBZip2OutputStream;
import org.apache.commons.vfs.provider.compressed.CompressedFileFileObject;
import org.apache.commons.vfs.provider.compressed.CompressedFileFileSystem;

public class Bzip2FileObject
extends CompressedFileFileObject {
    protected Bzip2FileObject(FileName fileName, FileObject fileObject, CompressedFileFileSystem compressedFileFileSystem) {
        super(fileName, fileObject, compressedFileFileSystem);
    }

    protected InputStream doGetInputStream() throws Exception {
        InputStream inputStream = this.getContainer().getContent().getInputStream();
        return Bzip2FileObject.wrapInputStream(this.getName().getURI(), inputStream);
    }

    public static InputStream wrapInputStream(String string, InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n != 66 || n2 != 90) {
            throw new FileSystemException("vfs.provider.compressedFile/not-a-compressedFile-file.error", string);
        }
        return new CBZip2InputStream(inputStream);
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        OutputStream outputStream = this.getContainer().getContent().getOutputStream(false);
        outputStream.write(66);
        outputStream.write(90);
        return new CBZip2OutputStream(outputStream);
    }
}

