/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.http.HttpFileObject;
import org.apache.commons.vfs.provider.http.HttpFileProvider;

public class HttpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final HttpClient client;

    protected HttpFileSystem(GenericFileName genericFileName, HttpClient httpClient, FileSystemOptions fileSystemOptions) {
        super(genericFileName, null, fileSystemOptions);
        this.client = httpClient;
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(HttpFileProvider.capabilities);
    }

    protected HttpClient getClient() {
        return this.client;
    }

    protected FileObject createFile(FileName fileName) throws Exception {
        return new HttpFileObject(fileName, this);
    }
}

