/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

class TarBuffer {
    private byte[] m_blockBuffer;
    private int m_blockSize;
    private int m_currBlkIdx;
    private int m_currRecIdx;
    private boolean m_debug;
    private InputStream m_input;
    private OutputStream m_output;
    private int m_recordSize;
    private int m_recsPerBlock;

    TarBuffer(InputStream inputStream, int n, int n2) {
        this.m_input = inputStream;
        this.initialize(n, n2);
    }

    public int getRecordSize() {
        return this.m_recordSize;
    }

    public boolean isEOFRecord(byte[] byArray) {
        int n = this.getRecordSize();
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void close() throws IOException {
        if (this.m_debug) {
            this.debug("TarBuffer.closeBuffer().");
        }
        if (null != this.m_output) {
            this.flushBlock();
            if (this.m_output != System.out && this.m_output != System.err) {
                this.m_output.close();
                this.m_output = null;
            }
        } else if (this.m_input != null && this.m_input != System.in) {
            this.m_input.close();
            this.m_input = null;
        }
    }

    public byte[] readRecord() throws IOException {
        Object object;
        if (this.m_debug) {
            object = "ReadRecord: recIdx = " + this.m_currRecIdx + " blkIdx = " + this.m_currBlkIdx;
            this.debug((String)object);
        }
        if (null == this.m_input) {
            throw new IOException("reading from an output buffer");
        }
        if (this.m_currRecIdx >= this.m_recsPerBlock && !this.readBlock()) {
            return null;
        }
        object = new byte[this.m_recordSize];
        System.arraycopy(this.m_blockBuffer, this.m_currRecIdx * this.m_recordSize, object, 0, this.m_recordSize);
        ++this.m_currRecIdx;
        return object;
    }

    private void flushBlock() throws IOException {
        if (this.m_debug) {
            this.debug("TarBuffer.flushBlock() called.");
        }
        if (this.m_output == null) {
            throw new IOException("writing to an input buffer");
        }
        if (this.m_currRecIdx > 0) {
            this.writeBlock();
        }
    }

    private void initialize(int n, int n2) {
        this.m_debug = false;
        this.m_blockSize = n;
        this.m_recordSize = n2;
        this.m_recsPerBlock = this.m_blockSize / this.m_recordSize;
        this.m_blockBuffer = new byte[this.m_blockSize];
        if (null != this.m_input) {
            this.m_currBlkIdx = -1;
            this.m_currRecIdx = this.m_recsPerBlock;
        } else {
            this.m_currBlkIdx = 0;
            this.m_currRecIdx = 0;
        }
    }

    private boolean readBlock() throws IOException {
        if (this.m_debug) {
            String string = "ReadBlock: blkIdx = " + this.m_currBlkIdx;
            this.debug(string);
        }
        if (null == this.m_input) {
            throw new IOException("reading from an output buffer");
        }
        this.m_currRecIdx = 0;
        int n = 0;
        int n2 = this.m_blockSize;
        while (n2 > 0) {
            long l = this.m_input.read(this.m_blockBuffer, n, n2);
            if (l == -1L) {
                Arrays.fill(this.m_blockBuffer, n, n + n2, (byte)0);
                break;
            }
            n = (int)((long)n + l);
            n2 = (int)((long)n2 - l);
            if (l == (long)this.m_blockSize || !this.m_debug) continue;
            System.err.println("ReadBlock: INCOMPLETE READ " + l + " of " + this.m_blockSize + " bytes read.");
        }
        ++this.m_currBlkIdx;
        return true;
    }

    private void writeBlock() throws IOException {
        if (this.m_debug) {
            String string = "WriteBlock: blkIdx = " + this.m_currBlkIdx;
            this.debug(string);
        }
        if (null == this.m_output) {
            throw new IOException("writing to an input buffer");
        }
        this.m_output.write(this.m_blockBuffer, 0, this.m_blockSize);
        this.m_output.flush();
        this.m_currRecIdx = 0;
        ++this.m_currBlkIdx;
    }

    protected void debug(String string) {
        if (this.m_debug) {
            System.err.println(string);
        }
    }
}

