/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Database;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.dom.DOMParser;

public class ManagedServer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$server$ManagedServer == null ? (class$org$apache$xindice$server$ManagedServer = ManagedServer.class$("org.apache.xindice.server.ManagedServer")) : class$org$apache$xindice$server$ManagedServer));
    private Database db;
    private boolean running;
    static /* synthetic */ Class class$org$apache$xindice$server$ManagedServer;

    public synchronized void start() throws Exception {
        if (!this.running) {
            this.configure();
            this.running = true;
        } else {
            log.warn((Object)"Start called on a running server, ignored");
        }
    }

    public synchronized void stop() throws Exception {
        if (this.running) {
            this.db.close();
            this.db = null;
            this.running = false;
        } else {
            log.warn((Object)"Stop called on a stopped server, ignored");
        }
    }

    public synchronized void configure() throws IOException, XindiceException {
        this.db = Database.getDatabase(this.loadConfiguration());
        if (null == this.db) {
            log.fatal((Object)"Unable to configure database");
            throw new XindiceException("Unable to configure database");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Database name: '" + this.db.getName() + "'"));
        }
    }

    protected Configuration loadConfiguration() throws IOException, XindiceException {
        Configuration config;
        String configDir = null;
        String configFile = System.getProperty("xindice.configuration");
        if (configFile != null && !configFile.equals("")) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Specified configuration file: '" + configFile + "'"));
            }
            FileInputStream configXMLFile = new FileInputStream(new File(configFile));
            config = new Configuration(DOMParser.toDocument(configXMLFile), false);
            configDir = new File(configFile).getAbsoluteFile().getParent();
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)"No configuration file specified, going with the default configuration");
            }
            config = new Configuration(DOMParser.toDocument("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"), false);
        }
        config = config.getChild("root-collection", false);
        String dbRoot = config.getAttribute("dbroot", "./db/");
        if (!new File(dbRoot).isAbsolute()) {
            String home = System.getProperty("xindice.db.home");
            if (home != null) {
                dbRoot = new File(home + File.separator + dbRoot).getCanonicalPath();
            } else if (configDir != null) {
                dbRoot = configDir + File.separator + dbRoot;
            } else {
                dbRoot = new File("." + File.separator + dbRoot).getCanonicalPath();
                log.warn((Object)"The database configuration file is not specified and there was no xindice.db.home property set, so Xindice was unable to determine a database location. Database will be created relative to the current directory.");
            }
            config.setAttribute("dbroot", dbRoot);
        }
        return config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

