/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.TestCase;
import org.apache.lucene.util.RandomAccessInputStream;

public class RandomAccessInputStreamTest
extends TestCase {
    private File testFile;

    protected void setUp() throws Exception {
        this.testFile = File.createTempFile("RandomAccessInputStreamTest", null);
        FileOutputStream out = new FileOutputStream(this.testFile);
        byte[] byArray = new byte[10];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        out.write(byArray);
        out.close();
    }

    public void testStream() throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.testFile, "r");
        RandomAccessInputStreamTest.assertEquals((int)raf.read(), (int)0);
        RandomAccessInputStreamTest.assertEquals((int)raf.read(), (int)1);
        RandomAccessInputStreamTest.assertEquals((long)raf.getFilePointer(), (long)2L);
        RandomAccessInputStream in = new RandomAccessInputStream(raf);
        RandomAccessInputStreamTest.assertEquals((long)in.getFilePointer(), (long)2L);
        RandomAccessInputStreamTest.assertEquals((int)in.read(), (int)2);
        in.seek(6L);
        RandomAccessInputStreamTest.assertEquals((int)in.read(), (int)6);
        in.seek(0L);
        RandomAccessInputStreamTest.assertEquals((int)in.read(), (int)0);
        in.close();
    }

    protected void tearDown() throws Exception {
        this.testFile.delete();
    }
}

