/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.spelt.SpellWriter;
import org.apache.lucene.util.ProgressTracker;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public class IdxTreeDictMaker {
    public void processDir(File dir) throws Exception {
        if (dir.getAbsoluteFile().isDirectory()) {
            if (IndexReader.indexExists(dir.getAbsoluteFile())) {
                this.makeDict(dir);
            } else {
                String[] files = dir.getAbsoluteFile().list();
                int i = 0;
                while (i < files.length) {
                    this.processDir(new File(dir, files[i]));
                    ++i;
                }
            }
            return;
        }
    }

    public void makeDict(File mainIdxDir) throws Exception {
        String indexPath = Path.normalizePath(mainIdxDir.toString());
        String spellIdxPath = String.valueOf(indexPath) + "spellDict/";
        String wordQueuePath = String.valueOf(spellIdxPath) + "newWords.txt";
        String pairQueuePath = String.valueOf(spellIdxPath) + "newPairs.txt";
        if (new File(wordQueuePath).length() < 1L && new File(pairQueuePath).length() < 1L) {
            return;
        }
        String mainIdxPath = Path.normalizePath(mainIdxDir.toString());
        Trace.info("Index: [" + mainIdxPath + "] ... ");
        Trace.tab();
        Trace.tab();
        SpellWriter spellWriter = null;
        try {
            try {
                spellWriter = SpellWriter.open(new File(spellIdxPath));
                spellWriter.setMinWordFreq(3);
                spellWriter.flushQueuedWords(new ProgressTracker(){

                    public void report(int pctDone, String descrip) {
                        String pctTxt = Integer.toString(pctDone);
                        while (pctTxt.length() < 3) {
                            pctTxt = " " + pctTxt;
                        }
                        Trace.info("[" + pctTxt + "%] " + descrip);
                    }
                });
            }
            catch (Exception e) {
                Trace.error("*** Dictionary Creation Halted Due to Error:" + e);
                throw e;
            }
        }
        finally {
            spellWriter.close();
        }
        Trace.untab();
        Trace.untab();
        Trace.info("Done.");
    }
}

