/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.spelt.SpellWriter;

public class SpellWritingFilter
extends TokenFilter {
    private SpellWriter writer;
    private boolean firstTime = true;

    public SpellWritingFilter(TokenStream input, SpellWriter writer) {
        super(input);
        this.writer = writer;
    }

    public Token next() throws IOException {
        Token t = this.input.next();
        if (t == null) {
            return t;
        }
        if (this.firstTime) {
            this.writer.queueBreak();
            this.firstTime = false;
        }
        String word = t.termText();
        boolean skip = false;
        if (word.charAt(0) == '\uebeb') {
            skip = true;
        } else if (word.charAt(word.length() - 1) == '\uee1d') {
            skip = true;
        } else {
            int i = 0;
            while (i < word.length()) {
                char c = word.charAt(i);
                if (Character.isDigit(c) || c == '\ue111' || c == '\ue112') {
                    skip = true;
                    break;
                }
                ++i;
            }
        }
        if (!skip) {
            if (t.getPositionIncrement() != 1) {
                this.writer.queueBreak();
            }
            this.writer.queueWord(word);
        } else {
            this.writer.queueBreak();
        }
        return t;
    }
}

