/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.IOException;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.StructuredFile;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.SubStoreReader;
import org.cdlib.xtf.util.SubStoreWriter;

public class StructuredFileProxy
implements StructuredStore {
    private File finalPath;
    private File tmpPath;
    private StructuredFile realStore = null;

    public StructuredFileProxy(File path) {
        this.finalPath = path;
        this.tmpPath = new File(String.valueOf(path.toString()) + ".tmp");
    }

    public SubStoreWriter createSubStore(String name) throws IOException {
        return this.realStore().createSubStore(name);
    }

    public SubStoreReader openSubStore(String name) throws IOException {
        return this.realStore().openSubStore(name);
    }

    public void close() throws IOException {
        if (this.realStore != null) {
            this.realStore.close();
        }
        if (this.tmpPath != null && !this.tmpPath.renameTo(this.finalPath)) {
            throw new IOException("Error renaming temporary store to final: " + this.finalPath);
        }
        this.realStore = null;
        this.tmpPath = null;
        this.finalPath = null;
    }

    public void delete() throws IOException {
        if (this.realStore != null) {
            this.realStore.delete();
        }
        if (this.tmpPath.canRead()) {
            this.tmpPath.delete();
        }
        this.realStore = null;
        this.tmpPath = null;
        this.finalPath = null;
    }

    public String getSystemId() {
        return this.realStore().getSystemId();
    }

    public void setUserVersion(String ver) throws IOException {
        this.realStore().setUserVersion(ver);
    }

    public String getUserVersion() {
        return this.realStore().getUserVersion();
    }

    private StructuredFile realStore() {
        try {
            if (this.realStore == null) {
                if (this.finalPath.canRead()) {
                    this.finalPath.delete();
                }
                if (this.tmpPath.canRead()) {
                    this.tmpPath.delete();
                }
                Path.createPath(this.finalPath.getParent());
                this.realStore = StructuredFile.create(this.tmpPath);
            }
            return this.realStore;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

