/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class XtfSpecialTokensFilter
extends TokenFilter {
    private String srcText;

    public XtfSpecialTokensFilter(TokenStream srcTokens, String srcText) {
        super(srcTokens);
        this.srcText = srcText;
    }

    public Token next() throws IOException {
        int defaultWordBump;
        int bumpValue = defaultWordBump = 1;
        Token theToken = null;
        while ((theToken = this.input.next()) != null) {
            int wordStart = theToken.startOffset();
            int wordEnd = theToken.endOffset();
            int startMark = 32;
            int endMark = 32;
            if (wordStart != 0) {
                startMark = this.srcText.charAt(wordStart - 1);
            }
            if (wordEnd != this.srcText.length()) {
                endMark = this.srcText.charAt(wordEnd);
            }
            if (startMark != 60347 || endMark != 60347) {
                theToken.setPositionIncrement(bumpValue);
                return theToken;
            }
            String text = theToken.termText();
            if (text.equals("x")) {
                bumpValue += 1000000;
                continue;
            }
            bumpValue += Integer.parseInt(text);
        }
        return null;
    }
}

