/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.util.Arrays;
import org.cdlib.xtf.util.ArrayUtil;

public class FloatList {
    private float[] data;
    private int size = 0;

    public FloatList() {
        this(10);
    }

    public FloatList(int initialCapacity) {
        this.data = new float[initialCapacity];
    }

    public final void add(float value) {
        if (this.size == this.data.length) {
            this.data = ArrayUtil.expand(this.data);
        }
        this.data[this.size++] = value;
    }

    public final void ensureCapacity(int cap) {
        if (cap > this.data.length) {
            this.data = ArrayUtil.resize(this.data, cap);
        }
    }

    public final void compact() {
        if (this.size != this.data.length) {
            this.data = ArrayUtil.resize(this.data, this.size);
        }
    }

    public final void resize(int newSize) {
        if (newSize != this.size) {
            this.data = ArrayUtil.resize(this.data, newSize);
            if (newSize > this.size) {
                Arrays.fill(this.data, this.size, newSize, 0.0f);
            }
            this.size = newSize;
        }
    }

    public final float[] toArray() {
        float[] ret = new float[this.size];
        System.arraycopy(this.data, 0, ret, 0, this.size);
        return ret;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        this.size = 0;
    }

    public final int size() {
        return this.size;
    }

    public final float get(int index) {
        return this.data[index];
    }

    public final float getLast() {
        return this.data[this.size - 1];
    }

    public final void set(int index, float value) {
        this.data[index] = value;
    }

    public final void fill(float value) {
        Arrays.fill(this.data, value);
    }

    public final void sort() {
        this.compact();
        Arrays.sort(this.data);
    }

    public final int binarySearch(float searchFor) {
        this.sort();
        return Arrays.binarySearch(this.data, searchFor);
    }
}

