/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.util.Iterator;
import java.util.LinkedList;
import org.cdlib.xtf.util.Trace;

public abstract class Tester {
    private static LinkedList allTests = new LinkedList();
    private String name;
    private boolean testedAlready;

    public Tester(String name) {
        this.name = name;
        allTests.add(this);
    }

    public static final void testAll() {
        Iterator iter = allTests.iterator();
        while (iter.hasNext()) {
            ((Tester)iter.next()).test();
        }
    }

    public final void test() {
        if (this.testedAlready) {
            return;
        }
        this.testedAlready = true;
        boolean ok = false;
        if (!$assertionsDisabled) {
            ok = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!ok) {
            throw new AssertionError((Object)"Must turn on assertions for test()");
        }
        Trace.info("Running test '" + this.name + "'...");
        try {
            this.testImpl();
        }
        catch (Exception e) {
            Trace.error("... Test '" + this.name + "' failed: " + e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        Trace.info("... Test '" + this.name + "' passed.");
    }

    protected abstract void testImpl() throws Exception;
}

