/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.WeakHashMap;

public class Trace {
    public static final int silent = 0;
    public static final int errors = 1;
    public static final int warnings = 2;
    public static final int info = 4;
    public static final int debug = 8;
    public static int defaultTabSize = 2;
    public static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss");
    private static final WeakHashMap threadTraces = new WeakHashMap();
    private static Trace prevTrace = null;
    private static Trace firstTrace = null;
    private static int nThreads = 0;
    private static PrintStream printStream = System.out;
    private static Writer writer = null;
    private static int prevMsgLevel = 0;
    private static int outputMask = 7;
    private static boolean printTimestamps = false;
    private static boolean autoFlush = false;
    private static final String spaces = "                                                                                                                                                                                                                  ";
    private String threadId = "";
    private int tabCount = 0;
    private int tabSize = defaultTabSize;

    public static void setOutputLevel(int level) {
        outputMask = 0;
        if (level >= 1) {
            outputMask |= 1;
        }
        if (level >= 2) {
            outputMask |= 2;
        }
        if (level >= 4) {
            outputMask |= 4;
        }
        if (level >= 8) {
            outputMask |= 8;
        }
    }

    public static int getOutputLevel() {
        if ((outputMask & 8) != 0) {
            return 8;
        }
        if ((outputMask & 4) != 0) {
            return 4;
        }
        if ((outputMask & 2) != 0) {
            return 2;
        }
        if ((outputMask & 1) != 0) {
            return 1;
        }
        return 0;
    }

    public static void printTimestamps(boolean flag) {
        printTimestamps = flag;
    }

    public static void setAutoFlush(boolean flag) {
        autoFlush = flag;
    }

    public static void tab() {
        Trace.getThreadTrace().t_tab();
    }

    private void t_tab() {
        this.tabCount += this.tabSize;
    }

    public static void untab() {
        Trace.getThreadTrace().t_untab();
    }

    private void t_untab() {
        this.tabCount -= this.tabSize;
        if (this.tabCount < 0) {
            this.tabCount = 0;
        }
    }

    public static void clearTabs() {
        Trace.getThreadTrace().t_clearTabs();
    }

    private void t_clearTabs() {
        this.tabCount = 0;
    }

    public static void setPrintStream(PrintStream pstream) {
        printStream = pstream;
        writer = null;
    }

    public static void setWriter(Writer w) {
        writer = w;
        printStream = null;
    }

    public static String getCurrentThreadId() {
        return Trace.getThreadTrace().threadId;
    }

    public static String getThreadId(Thread thread) {
        Trace trace = (Trace)threadTraces.get(thread);
        if (trace == null) {
            return null;
        }
        return trace.threadId;
    }

    public static void error(String msg) {
        Trace.getThreadTrace().t_error(msg);
    }

    public static void error(String msg, Object ... args) {
        Trace.getThreadTrace().t_error(String.format(msg, args));
    }

    private void t_error(String msg) {
        prevMsgLevel = 1;
        if ((outputMask & 1) == 0) {
            return;
        }
        this.output(msg, true, true);
    }

    public static void warning(String msg) {
        Trace.getThreadTrace().t_warning(msg);
    }

    public static void warning(String msg, Object ... args) {
        Trace.getThreadTrace().t_warning(String.format(msg, args));
    }

    private void t_warning(String msg) {
        prevMsgLevel = 2;
        if ((outputMask & 2) == 0) {
            return;
        }
        this.output(msg, true, true);
    }

    public static void info(String msg) {
        Trace.getThreadTrace().t_info(msg);
    }

    public static void info(String msg, Object ... args) {
        Trace.getThreadTrace().t_info(String.format(msg, args));
    }

    private void t_info(String msg) {
        prevMsgLevel = 4;
        if ((outputMask & 4) == 0) {
            return;
        }
        this.output(msg, true, true);
    }

    public static void debug(String msg) {
        Trace.getThreadTrace().t_debug(msg);
    }

    public static void debug(String msg, Object ... args) {
        Trace.getThreadTrace().t_debug(String.format(msg, args));
    }

    private void t_debug(String msg) {
        prevMsgLevel = 8;
        if ((outputMask & 8) == 0) {
            return;
        }
        this.output(msg, true, true);
    }

    public static void more(String msg) {
        Trace.getThreadTrace().t_more(msg);
    }

    private void t_more(String msg) {
        if ((outputMask & prevMsgLevel) == 0) {
            return;
        }
        this.output(msg, false, false);
    }

    public static void more(int level, String msg) {
        Trace.getThreadTrace().t_more(level, msg);
    }

    private void t_more(int level, String msg) {
        if (prevMsgLevel != level && (prevMsgLevel & outputMask) != 0) {
            this.output("", true, true);
        }
        prevMsgLevel = level;
        Trace.more(msg);
    }

    private static Trace getThreadTrace() {
        Trace trace = (Trace)threadTraces.get(Thread.currentThread());
        if (trace == null) {
            trace = new Trace();
            threadTraces.put(Thread.currentThread(), trace);
        }
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Trace() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            ++nThreads;
            if (firstTrace == null) {
                this.threadId = "";
                firstTrace = this;
            } else {
                assert (nThreads >= 2);
                if (Trace.firstTrace.threadId.length() == 0) {
                    Trace.firstTrace.threadId = "[1] ";
                }
                this.threadId = "[" + nThreads + "] ";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(String msg, boolean tabbed, boolean linefeed) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (prevTrace != this) {
                tabbed = true;
                linefeed = true;
                prevTrace = this;
            }
            String outMsg = tabbed ? String.valueOf(spaces.substring(0, this.tabCount)) + msg : msg;
            try {
                if (linefeed) {
                    String newLine = autoFlush ? "" : "\n";
                    String dateStr = "";
                    if (printTimestamps) {
                        dateStr = String.valueOf(dateFormat.format(new Date(System.currentTimeMillis()))) + " ";
                    }
                    if (writer != null) {
                        writer.write(String.valueOf(newLine) + dateStr + this.threadId);
                    } else {
                        printStream.print(String.valueOf(newLine) + dateStr + this.threadId);
                    }
                }
                if (writer != null) {
                    writer.write(autoFlush ? String.valueOf(outMsg) + "\n" : outMsg);
                } else {
                    printStream.print(autoFlush ? String.valueOf(outMsg) + "\n" : outMsg);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

