/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.marc4j.MarcHandler;
import org.marc4j.marc.Leader;

public class TaggedWriter
implements MarcHandler {
    private Writer out;

    public TaggedWriter() throws IOException {
        this(System.out);
    }

    public TaggedWriter(OutputStream outputStream) throws IOException {
        this(new OutputStreamWriter(outputStream));
    }

    public TaggedWriter(OutputStream outputStream, String string) throws IOException {
        this(new OutputStreamWriter(outputStream, string));
    }

    public TaggedWriter(Writer writer) {
        this.setWriter(writer);
    }

    public void setWriter(Writer writer) {
        this.out = writer;
    }

    public void startCollection() {
        if (this.out == null) {
            System.exit(0);
        }
    }

    public void startRecord(Leader leader) {
        this.rawWrite("Leader ");
        this.rawWrite(leader.marshal());
        this.rawWrite('\n');
    }

    public void controlField(String string, char[] cArray) {
        this.rawWrite(string);
        this.rawWrite(' ');
        this.rawWrite(new String(cArray));
        this.rawWrite('\n');
    }

    public void startDataField(String string, char c, char c2) {
        this.rawWrite(string);
        this.rawWrite(' ');
        this.rawWrite(c);
        this.rawWrite(c2);
    }

    public void subfield(char c, char[] cArray) {
        this.rawWrite('$');
        this.rawWrite(c);
        this.rawWrite(new String(cArray));
    }

    public void endDataField(String string) {
        this.rawWrite('\n');
    }

    public void endRecord() {
        this.rawWrite('\n');
    }

    public void endCollection() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void rawWrite(char c) {
        try {
            this.out.write(c);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void rawWrite(String string) {
        try {
            this.out.write(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

