/*
 * Decompiled with CFR 0.152.
 */
package org.exist.atom.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.atom.AtomModule;
import org.exist.atom.http.HttpRequestMessage;
import org.exist.atom.http.HttpResponseMessage;
import org.exist.atom.modules.AtomFeeds;
import org.exist.atom.modules.AtomProtocol;
import org.exist.atom.modules.Query;
import org.exist.http.BadRequestException;
import org.exist.http.NotFoundException;
import org.exist.http.servlets.Authenticator;
import org.exist.http.servlets.BasicAuthenticator;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.XmldbPrincipal;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.validation.XmlLibraryChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class AtomServlet
extends HttpServlet {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String CONF_NS = "http://www.exist-db.org/Vocabulary/AtomConfiguration/2006/1/0";
    protected static final Logger LOG = Logger.getLogger((Class)AtomServlet.class);
    private Map modules;
    private Map noAuth;
    private String formEncoding = null;
    private BrokerPool pool = null;
    private String defaultUsername = "guest";
    private String defaultPassword = "guest";
    private Authenticator authenticator;
    private User defaultUser;
    static /* synthetic */ Class class$org$exist$atom$Atom;

    public void init(ServletConfig config) throws ServletException {
        String containerEncoding;
        super.init(config);
        try {
            if (BrokerPool.isConfigured()) {
                LOG.debug((Object)"Database already started. Skipping configuration ...");
            } else {
                String confFile = config.getInitParameter("configuration");
                String dbHome = config.getInitParameter("basedir");
                String start = config.getInitParameter("start");
                if (confFile == null) {
                    confFile = "conf.xml";
                }
                dbHome = dbHome == null ? config.getServletContext().getRealPath(".") : config.getServletContext().getRealPath(dbHome);
                LOG.debug((Object)("AtomServlet: exist.home=" + dbHome));
                File f = new File(dbHome + File.separator + confFile);
                LOG.debug((Object)("reading configuration from " + f.getAbsolutePath()));
                if (!f.canRead()) {
                    throw new ServletException("configuration file " + confFile + " not found or not readable");
                }
                Configuration configuration = new Configuration(confFile, dbHome);
                if (start != null && start.equals("true")) {
                    this.startup(configuration);
                }
            }
            this.pool = BrokerPool.getInstance();
            String option = config.getInitParameter("use-default-user");
            boolean useDefaultUser = true;
            if (option != null) {
                useDefaultUser = option.trim().equals("true");
            }
            if (useDefaultUser) {
                option = config.getInitParameter("user");
                if (option != null) {
                    this.defaultUsername = option;
                }
                if ((option = config.getInitParameter("password")) != null) {
                    this.defaultPassword = option;
                }
                this.defaultUser = this.getDefaultUser();
                if (this.defaultUser != null) {
                    LOG.info((Object)("Using default user " + this.defaultUsername + " for all unauthorized requests."));
                } else {
                    LOG.error((Object)("Default user " + this.defaultUsername + " cannot be found.  A BASIC AUTH challenge will be the default."));
                }
            } else {
                LOG.info((Object)"No default user.  All requires must be authorized or will result in a BASIC AUTH challenge.");
                this.defaultUser = null;
            }
            this.authenticator = new BasicAuthenticator(this.pool);
        }
        catch (EXistException e) {
            throw new ServletException("No database instance available");
        }
        catch (DatabaseConfigurationException e) {
            throw new ServletException("Unable to configure database instance: " + e.getMessage(), (Throwable)e);
        }
        this.formEncoding = config.getInitParameter("form-encoding");
        if (this.formEncoding == null) {
            this.formEncoding = DEFAULT_ENCODING;
        }
        if ((containerEncoding = config.getInitParameter("container-encoding")) == null) {
            containerEncoding = DEFAULT_ENCODING;
        }
        this.modules = new HashMap();
        this.noAuth = new HashMap();
        String configFileOpt = config.getInitParameter("config-file");
        File dbHome = this.pool.getConfiguration().getExistHome();
        File atomConf = configFileOpt == null ? new File(dbHome, "atom-services.xml") : new File(config.getServletContext().getRealPath(configFileOpt));
        config.getServletContext().log("Checking for atom configuration in " + atomConf.getAbsolutePath());
        if (atomConf.exists()) {
            config.getServletContext().log("Loading configuration " + atomConf.getAbsolutePath());
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = null;
            Document confDoc = null;
            FileInputStream is = null;
            try {
                is = new FileInputStream(atomConf);
                InputSource src = new InputSource(new InputStreamReader((InputStream)is, this.formEncoding));
                URI docBaseURI = atomConf.toURI();
                src.setSystemId(docBaseURI.toString());
                docBuilder = docFactory.newDocumentBuilder();
                confDoc = docBuilder.parse(src);
                confDoc.getDocumentElement();
                NodeList moduleConfList = confDoc.getElementsByTagNameNS(CONF_NS, "module");
                for (int i = 0; i < moduleConfList.getLength(); ++i) {
                    String className;
                    Element moduleConf = (Element)moduleConfList.item(i);
                    String name = moduleConf.getAttribute("name");
                    if (this.modules.get(name) != null) {
                        throw new ServletException("Module '" + name + "' is configured more than once ( child # " + (i + 1));
                    }
                    if ("false".equals(moduleConf.getAttribute("authenticate"))) {
                        this.noAuth.put(name, Boolean.TRUE);
                    }
                    if ((className = moduleConf.getAttribute("class")) != null && className.length() > 0) {
                        try {
                            Class<?> moduleClass = Class.forName(className);
                            AtomModule amodule = (AtomModule)moduleClass.newInstance();
                            this.modules.put(name, amodule);
                            amodule.init(new ModuleContext(config, name, atomConf.getParent()));
                            continue;
                        }
                        catch (Exception ex) {
                            throw new ServletException("Cannot instantiate class " + className + " for module '" + name + "' due to exception: " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                    Query query = new Query();
                    this.modules.put(name, query);
                    String allowQueryPost = moduleConf.getAttribute("query-by-post");
                    if ("true".equals(allowQueryPost)) {
                        query.setQueryByPost(true);
                    }
                    NodeList methodList = moduleConf.getElementsByTagNameNS(CONF_NS, "method");
                    for (int m = 0; m < methodList.getLength(); ++m) {
                        Element methodConf = (Element)methodList.item(m);
                        String type = methodConf.getAttribute("type");
                        if (type == null) {
                            LOG.warn((Object)("No type specified for method in module " + name));
                            continue;
                        }
                        URI baseURI = docBaseURI;
                        String queryRef = methodConf.getAttribute("query");
                        if (queryRef == null) {
                            LOG.warn((Object)("No query specified for method " + type + " in module " + name));
                            continue;
                        }
                        boolean fromClasspath = "true".equals(methodConf.getAttribute("from-classpath"));
                        Query.MethodConfiguration mconf = query.getMethodConfiguration(type);
                        if (mconf == null) {
                            LOG.warn((Object)("Unknown method " + type + " in module " + name));
                            continue;
                        }
                        String responseContentType = methodConf.getAttribute("content-type");
                        if (responseContentType != null && responseContentType.trim().length() != 0) {
                            mconf.setContentType(responseContentType);
                        }
                        URL queryURI = null;
                        if (fromClasspath) {
                            LOG.debug((Object)("Nope. Attempting to get resource " + queryRef + " from " + (class$org$exist$atom$Atom == null ? AtomServlet.class$("org.exist.atom.Atom") : class$org$exist$atom$Atom).getName()));
                            queryURI = (class$org$exist$atom$Atom == null ? AtomServlet.class$("org.exist.atom.Atom") : class$org$exist$atom$Atom).getResource(queryRef);
                        } else {
                            queryURI = baseURI.resolve(queryRef).toURL();
                        }
                        LOG.debug((Object)("Loading from module " + name + " method " + type + " from resource " + queryURI + " via classpath(" + fromClasspath + ") and ref (" + queryRef + ")"));
                        if (queryURI == null) {
                            throw new ServletException("Cannot find resource " + queryRef + " for module " + name);
                        }
                        mconf.setQuerySource(queryURI);
                    }
                    query.init(new ModuleContext(config, name, atomConf.getParent()));
                }
            }
            catch (IOException e) {
                LOG.warn((Object)e);
                throw new ServletException(e.getMessage());
            }
            catch (SAXException e) {
                LOG.warn((Object)e);
                throw new ServletException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                LOG.warn((Object)e);
                throw new ServletException(e.getMessage());
            }
            catch (EXistException e) {
                LOG.warn((Object)e);
                throw new ServletException(e.getMessage());
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        try {
            AtomProtocol protocol = new AtomProtocol();
            this.modules.put("edit", protocol);
            protocol.init(new ModuleContext(config, "edit", dbHome.getAbsolutePath()));
            AtomFeeds feeds = new AtomFeeds();
            this.modules.put("content", feeds);
            feeds.init(new ModuleContext(config, "content", dbHome.getAbsolutePath()));
            Query query = new Query();
            query.setQueryByPost(true);
            this.modules.put("query", query);
            query.init(new ModuleContext(config, "query", dbHome.getAbsolutePath()));
            Query topics = new Query();
            this.modules.put("topic", topics);
            topics.getMethodConfiguration("GET").setQuerySource(topics.getClass().getResource("topic.xq"));
            topics.init(new ModuleContext(config, "topic", dbHome.getAbsolutePath()));
            Query introspect = new Query();
            this.modules.put("introspect", introspect);
            introspect.getMethodConfiguration("GET").setQuerySource(introspect.getClass().getResource("introspect.xq"));
            introspect.init(new ModuleContext(config, "introspect", dbHome.getAbsolutePath()));
        }
        catch (EXistException ex) {
            throw new ServletException("Exception during module init(): " + ex.getMessage(), (Throwable)ex);
        }
        StringBuffer xmlLibMessage = new StringBuffer();
        if (XmlLibraryChecker.hasValidParser(xmlLibMessage)) {
            LOG.info((Object)xmlLibMessage);
        } else {
            LOG.warn((Object)xmlLibMessage);
        }
        xmlLibMessage.delete(0, xmlLibMessage.length());
        if (XmlLibraryChecker.hasValidTransformer(xmlLibMessage)) {
            LOG.info((Object)xmlLibMessage);
        } else {
            LOG.warn((Object)xmlLibMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String path = request.getPathInfo();
            if (path == null) {
                response.sendError(400, "URL has no extra path information specified.");
                return;
            }
            int firstSlash = path.indexOf(47, 1);
            if (firstSlash < 0 && path.length() == 1) {
                response.sendError(400, "Module not specified.");
                return;
            }
            String moduleName = firstSlash < 0 ? path.substring(1) : path.substring(1, firstSlash);
            path = firstSlash < 0 ? "" : path.substring(firstSlash);
            AtomModule module = (AtomModule)this.modules.get(moduleName);
            if (module == null) {
                response.sendError(400, "Module " + moduleName + " not found.");
                return;
            }
            User user = null;
            if (this.noAuth.get(moduleName) == null && (user = this.authenticate(request, response)) == null) {
                return;
            }
            final UserXmldbPrincipal principal = new UserXmldbPrincipal(0, user);
            HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

                public Principal getUserPrincipal() {
                    return principal;
                }
            };
            DBBroker broker = null;
            try {
                broker = this.pool.get(user);
                module.process(broker, new HttpRequestMessage(request, path, '/' + moduleName), new HttpResponseMessage(response));
            }
            catch (NotFoundException ex) {
                LOG.info((Object)("Resource " + path + " not found by " + moduleName), (Throwable)ex);
                response.sendError(404, ex.getMessage());
            }
            catch (PermissionDeniedException ex) {
                LOG.info((Object)("Permission denied to " + path + " by " + moduleName + " for " + user.getName()), (Throwable)ex);
                response.sendError(401, ex.getMessage());
            }
            catch (BadRequestException ex) {
                LOG.info((Object)("Bad request throw from module " + moduleName), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
            catch (EXistException ex) {
                LOG.fatal((Object)("Exception getting broker from pool for user " + user.getName()), (Throwable)ex);
                response.sendError(500, "Service is not available.");
            }
            finally {
                this.pool.release(broker);
            }
        }
        catch (IOException ex) {
            LOG.fatal((Object)"I/O exception on request.", (Throwable)ex);
            try {
                response.sendError(500, "Service is not available.");
            }
            catch (IOException finalEx) {
                LOG.fatal((Object)"Cannot return 500 on exception.", (Throwable)ex);
            }
        }
    }

    public void destroy() {
        super.destroy();
        BrokerPool.stopAll(false);
    }

    private User authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String auth;
        Principal principal = request.getUserPrincipal();
        if (principal instanceof XmldbPrincipal) {
            String username = ((XmldbPrincipal)principal).getName();
            String password = ((XmldbPrincipal)principal).getPassword();
            LOG.info((Object)("Validating Principle: " + principal.getName()));
            User user = this.pool.getSecurityManager().getUser(username);
            if (user != null) {
                if (password.equalsIgnoreCase(user.getPassword())) {
                    LOG.info((Object)("Valid User: " + user.getName()));
                    return user;
                }
                LOG.info((Object)("Password invalid for user: " + username));
                LOG.info((Object)("User not found: " + principal.getName()));
            }
        }
        if ((auth = request.getHeader("Authorization")) == null && this.defaultUser != null) {
            return this.defaultUser;
        }
        return this.authenticator.authenticate(request, response);
    }

    private User getDefaultUser() {
        if (this.defaultUsername != null) {
            User user = this.pool.getSecurityManager().getUser(this.defaultUsername);
            if (user != null && !user.validate(this.defaultPassword)) {
                return null;
            }
            return user;
        }
        return null;
    }

    private void startup(Configuration configuration) throws ServletException {
        if (configuration == null) {
            throw new ServletException("database has not been configured");
        }
        LOG.info((Object)"configuring eXist instance");
        try {
            if (!BrokerPool.isConfigured()) {
                BrokerPool.configure(1, 5, configuration);
            }
        }
        catch (EXistException e) {
            throw new ServletException(e.getMessage());
        }
        catch (DatabaseConfigurationException e) {
            throw new ServletException(e.getMessage());
        }
        try {
            LOG.info((Object)"registering XMLDB driver");
            Class<?> clazz = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)clazz.newInstance();
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (ClassNotFoundException e) {
            LOG.info((Object)"ERROR", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.info((Object)"ERROR", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.info((Object)"ERROR", (Throwable)e);
        }
        catch (XMLDBException e) {
            LOG.info((Object)"ERROR", (Throwable)e);
        }
    }

    class ModuleContext
    implements AtomModule.Context {
        ServletConfig config;
        String moduleLoadPath;

        ModuleContext(ServletConfig config, String subpath, String moduleLoadPath) {
            this.config = config;
            this.moduleLoadPath = moduleLoadPath;
        }

        public String getDefaultCharset() {
            return AtomServlet.this.formEncoding;
        }

        public String getParameter(String name) {
            return this.config.getInitParameter(name);
        }

        public String getContextPath() {
            return null;
        }

        public URL getContextURL() {
            return null;
        }

        public String getModuleLoadPath() {
            return this.moduleLoadPath;
        }
    }

    static class UserXmldbPrincipal
    implements XmldbPrincipal {
        int authMethod;
        User user;

        UserXmldbPrincipal(int authMethod, User user) {
            this.authMethod = authMethod;
            this.user = user;
        }

        public String getName() {
            return this.user.getName();
        }

        public String getPassword() {
            return this.authMethod == 0 ? this.user.getPassword() : this.user.getDigestPassword();
        }

        public boolean hasRole(String role) {
            return this.user.hasGroup(role);
        }
    }
}

