/*
 * Decompiled with CFR 0.152.
 */
package org.exist.atom.modules;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.exist.EXistException;
import org.exist.atom.AtomModule;
import org.exist.atom.IncomingMessage;
import org.exist.atom.OutgoingMessage;
import org.exist.http.BadRequestException;
import org.exist.http.NotFoundException;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;

public class AtomModuleBase
implements AtomModule {
    protected AtomModule.Context context;

    public void init(AtomModule.Context context) throws EXistException {
        this.context = context;
    }

    protected AtomModule.Context getContext() {
        return this.context;
    }

    public void process(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException, IOException {
        String method = request.getMethod();
        if (method.equals("GET")) {
            this.doGet(broker, request, response);
        } else if (method.equals("POST")) {
            this.doPost(broker, request, response);
        } else if (method.equals("PUT")) {
            this.doPut(broker, request, response);
        } else if (method.equals("HEAD")) {
            this.doHead(broker, request, response);
        } else if (method.equals("DELETE")) {
            this.doDelete(broker, request, response);
        } else {
            throw new BadRequestException("Method " + request.getMethod() + " is not supported by this module.");
        }
    }

    public void doGet(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        throw new BadRequestException("Method " + request.getMethod() + " is not supported by this module.");
    }

    public void doHead(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        throw new BadRequestException("Method " + request.getMethod() + " is not supported by this module.");
    }

    public void doPost(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        throw new BadRequestException("Method " + request.getMethod() + " is not supported by this module.");
    }

    public void doPut(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        throw new BadRequestException("Method " + request.getMethod() + " is not supported by this module.");
    }

    public void doDelete(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException, IOException {
        throw new BadRequestException("Method " + request.getMethod() + " is not supported by this module.");
    }

    protected File storeInTemporaryFile(InputStream is, int len) throws IOException {
        int count;
        File tempFile = File.createTempFile("atom", ".tmp");
        FileOutputStream os = new FileOutputStream(tempFile);
        byte[] buffer = new byte[4096];
        int l = 0;
        do {
            if ((count = is.read(buffer)) <= 0) continue;
            ((OutputStream)os).write(buffer, 0, count);
        } while (len < 0 && count >= 0 || (l += count) < len);
        ((OutputStream)os).close();
        return tempFile;
    }
}

