/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.exist.client.Messages;
import org.exist.xmldb.XmldbURI;

public class LoginPanel
extends JPanel {
    public static final int TYPE_REMOTE = 0;
    public static final int TYPE_EMBEDDED = 1;
    public static final String URI_EMBEDDED = XmldbURI.EMBEDDED_SERVER_URI.toString();
    public static final String URI_REMOTE = "xmldb:exist://localhost:8080/exist/xmlrpc";
    public static final String FAVOURITES_NODE = Messages.getString("LoginPanel.1");
    protected Properties properties;
    JTextField username;
    JPasswordField password;
    JTextField cur_url;
    JTextField configuration;
    JButton selectConf;
    JComboBox type;
    JList favourites;
    DefaultListModel favouritesModel;
    JTextField title;
    JButton btnAddFavourite;
    JButton btnRemoveFavourite;
    JButton btnLoadFavourite;
    JButton btnExportFavourite;
    JButton btnImportFavourite;

    public LoginPanel(Properties props) {
        super(false);
        this.properties = new Properties(props);
        this.setupComponents();
    }

    private void setupComponents() {
        String uri;
        GridBagLayout grid = new GridBagLayout();
        this.setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        int inset = 5;
        c.insets = new Insets(5, 5, 5, 5);
        int gridy = 0;
        JLabel label = new JLabel(Messages.getString("LoginPanel.2"));
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.username = new JTextField(this.properties.getProperty("user"), 12);
        c.gridx = 1;
        c.gridy = gridy++;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.username, c);
        this.add(this.username);
        label = new JLabel(Messages.getString("LoginPanel.3"));
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.password = new JPasswordField(12);
        c.gridx = 1;
        c.gridy = gridy++;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.password, c);
        this.add(this.password);
        label = new JLabel(Messages.getString("LoginPanel.4"));
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.type = new JComboBox();
        this.type.addItem(Messages.getString("LoginPanel.5"));
        boolean showEmbeddedMode = this.properties.getProperty("NO_EMBED_MODE", "FALSE").equalsIgnoreCase("FALSE");
        if (showEmbeddedMode) {
            this.type.addItem(Messages.getString("LoginPanel.6"));
        }
        this.type.setSelectedIndex((uri = this.properties.getProperty("uri")).equals(URI_EMBEDDED) ? 1 : 0);
        this.type.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                switch (LoginPanel.this.type.getSelectedIndex()) {
                    case 1: {
                        LoginPanel.this.cur_url.setText(URI_EMBEDDED);
                        LoginPanel.this.cur_url.setEnabled(false);
                        LoginPanel.this.configuration.setEnabled(true);
                        LoginPanel.this.selectConf.setEnabled(true);
                        break;
                    }
                    case 0: {
                        LoginPanel.this.cur_url.setText(!uri.equals(URI_EMBEDDED) ? uri : LoginPanel.URI_REMOTE);
                        LoginPanel.this.cur_url.setEnabled(true);
                        LoginPanel.this.configuration.setEnabled(false);
                        LoginPanel.this.selectConf.setEnabled(false);
                    }
                }
            }
        });
        c.gridx = 1;
        c.gridy = gridy++;
        c.gridwidth = 2;
        c.anchor = 17;
        grid.setConstraints(this.type, c);
        this.add(this.type);
        label = new JLabel(Messages.getString("LoginPanel.8"));
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.configuration = new JTextField(this.properties.getProperty("configuration"), 40);
        this.configuration.setToolTipText(Messages.getString("LoginPanel.9"));
        if (this.type.getSelectedIndex() == 0) {
            this.configuration.setEnabled(false);
        }
        c.gridx = 1;
        c.gridy = gridy;
        c.anchor = 13;
        c.fill = 2;
        grid.setConstraints(this.configuration, c);
        this.add(this.configuration);
        this.selectConf = new JButton(Messages.getString("LoginPanel.10"));
        this.selectConf.setToolTipText(Messages.getString("LoginPanel.11"));
        if (this.type.getSelectedIndex() == 0) {
            this.selectConf.setEnabled(false);
        }
        this.selectConf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String conf = LoginPanel.this.configuration.getText();
                if (conf == null) {
                    LoginPanel.this.selectConfFile(null);
                } else {
                    LoginPanel.this.selectConfFile(new File(conf).getParentFile());
                }
            }
        });
        c.gridx = 2;
        c.gridy = gridy++;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(this.selectConf, c);
        this.add(this.selectConf);
        label = new JLabel(Messages.getString("LoginPanel.12"));
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.cur_url = new JTextField(uri, 20);
        this.cur_url.setEnabled(!uri.equals(URI_EMBEDDED));
        c.gridx = 1;
        c.gridy = gridy++;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.cur_url, c);
        this.add(this.cur_url);
        label = new JLabel(Messages.getString("LoginPanel.13"));
        c.gridx = 0;
        c.gridy = ++gridy;
        c.gridwidth = 1;
        c.insets = new Insets(20, 5, 5, 5);
        c.anchor = 13;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.title = new JTextField();
        this.title.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent arg0) {
                LoginPanel.this.btnAddFavourite.setEnabled(LoginPanel.this.title.getText().length() > 0);
            }

            public void removeUpdate(DocumentEvent arg0) {
                LoginPanel.this.btnAddFavourite.setEnabled(LoginPanel.this.title.getText().length() > 0);
            }

            public void changedUpdate(DocumentEvent arg0) {
                LoginPanel.this.btnAddFavourite.setEnabled(LoginPanel.this.title.getText().length() > 0);
            }
        });
        c.gridx = 1;
        c.gridy = gridy++;
        c.gridwidth = 2;
        c.insets = new Insets(20, 5, 5, 5);
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.title, c);
        this.add(this.title);
        label = new JLabel(Messages.getString("LoginPanel.14"));
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.gridheight = 4;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 12;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.add(label);
        this.favouritesModel = new DefaultListModel();
        Favourite[] f = this.loadFavourites();
        int i = 0;
        while (i < f.length) {
            this.favouritesModel.addElement(f[i++]);
        }
        this.favourites = new JList(this.favouritesModel);
        this.favourites.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean selection = LoginPanel.this.favourites.getSelectedIndex() >= 0;
                LoginPanel.this.btnLoadFavourite.setEnabled(selection);
                LoginPanel.this.btnRemoveFavourite.setEnabled(selection);
            }
        });
        this.favourites.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2 && LoginPanel.this.favourites.getSelectedIndex() >= 0) {
                    Favourite f = (Favourite)LoginPanel.this.favourites.getSelectedValue();
                    LoginPanel.this.title.setText(f.getName());
                    LoginPanel.this.username.setText(f.getUsername());
                    LoginPanel.this.password.setText(f.getPassword());
                    LoginPanel.this.configuration.setText(f.getConfiguration());
                    LoginPanel.this.type.setSelectedIndex(URI_EMBEDDED.equals(f.getUrl()) ? 1 : 0);
                    LoginPanel.this.cur_url.setText(f.getUrl());
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.favourites);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setPreferredSize(new Dimension(200, 130));
        c.gridx = 1;
        c.gridy = gridy;
        c.gridheight = 4;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 18;
        c.fill = 2;
        grid.setConstraints(scroll, c);
        this.add(scroll);
        this.btnLoadFavourite = new JButton(Messages.getString("LoginPanel.15"));
        this.btnLoadFavourite.setToolTipText(Messages.getString("LoginPanel.16"));
        this.btnLoadFavourite.setEnabled(false);
        this.btnLoadFavourite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Favourite f = (Favourite)LoginPanel.this.favourites.getSelectedValue();
                LoginPanel.this.title.setText(f.getName());
                LoginPanel.this.username.setText(f.getUsername());
                LoginPanel.this.password.setText(f.getPassword());
                LoginPanel.this.configuration.setText(f.getConfiguration());
                LoginPanel.this.type.setSelectedIndex(URI_EMBEDDED.equals(f.getUrl()) ? 1 : 0);
                LoginPanel.this.cur_url.setText(f.getUrl());
            }
        });
        c.gridx = 2;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 15, 5);
        c.fill = 2;
        grid.setConstraints(this.btnLoadFavourite, c);
        this.add(this.btnLoadFavourite);
        this.btnAddFavourite = new JButton(Messages.getString("LoginPanel.17"));
        this.btnAddFavourite.setToolTipText(Messages.getString("LoginPanel.18"));
        this.btnAddFavourite.setEnabled(false);
        this.btnAddFavourite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String t = LoginPanel.this.title.getText();
                for (int i = 0; i < LoginPanel.this.favouritesModel.getSize(); ++i) {
                    if (!LoginPanel.this.favouritesModel.elementAt(i).equals(t)) continue;
                    int result = JOptionPane.showConfirmDialog(LoginPanel.this, Messages.getString("LoginPanel.19"), Messages.getString("LoginPanel.20"), 0);
                    if (result == 1) {
                        return;
                    }
                    LoginPanel.this.favouritesModel.remove(i);
                    break;
                }
                Favourite f = new Favourite(LoginPanel.this.title.getText(), LoginPanel.this.username.getText(), new String(LoginPanel.this.password.getPassword()), LoginPanel.this.cur_url.getText(), LoginPanel.this.configuration.getText());
                LoginPanel.this.favouritesModel.addElement(f);
                LoginPanel.this.storeFavourites(LoginPanel.this.favouritesModel);
            }
        });
        c.gridx = 2;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        grid.setConstraints(this.btnAddFavourite, c);
        this.add(this.btnAddFavourite);
        this.btnRemoveFavourite = new JButton(Messages.getString("LoginPanel.21"));
        this.btnRemoveFavourite.setEnabled(false);
        this.btnRemoveFavourite.setToolTipText(Messages.getString("LoginPanel.22"));
        this.btnRemoveFavourite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.favouritesModel.remove(LoginPanel.this.favourites.getSelectedIndex());
                LoginPanel.this.btnRemoveFavourite.setEnabled(false);
                LoginPanel.this.btnLoadFavourite.setEnabled(false);
                LoginPanel.this.storeFavourites(LoginPanel.this.favourites.getModel());
                LoginPanel.this.repaint();
            }
        });
        c.gridx = 2;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 5, 15, 5);
        c.fill = 2;
        grid.setConstraints(this.btnRemoveFavourite, c);
        this.add(this.btnRemoveFavourite);
        this.btnExportFavourite = new JButton(Messages.getString("LoginPanel.23"));
        this.btnExportFavourite.setEnabled(true);
        this.btnExportFavourite.setToolTipText(Messages.getString("LoginPanel.24"));
        this.btnExportFavourite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = new File(Messages.getString("LoginPanel.25"));
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(file);
                chooser.showSaveDialog(LoginPanel.this);
                File selectedFile = chooser.getSelectedFile();
                if (selectedFile == null) {
                    JOptionPane.showMessageDialog(LoginPanel.this, Messages.getString("LoginPanel.26"), Messages.getString("LoginPanel.27"), 0);
                    return;
                }
                if (selectedFile.exists() && !selectedFile.canWrite()) {
                    JOptionPane.showMessageDialog(LoginPanel.this, Messages.getString("LoginPanel.28"), Messages.getString("LoginPanel.29"), 0);
                    return;
                }
                LoginPanel.exportFavourites(selectedFile);
                LoginPanel.this.repaint();
            }
        });
        c.gridx = 2;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        grid.setConstraints(this.btnExportFavourite, c);
        this.add(this.btnExportFavourite);
        this.btnImportFavourite = new JButton(Messages.getString("LoginPanel.30"));
        this.btnImportFavourite.setEnabled(true);
        this.btnImportFavourite.setToolTipText(Messages.getString("LoginPanel.31"));
        this.btnImportFavourite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = new File("favourites.xml");
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(file);
                chooser.showOpenDialog(LoginPanel.this);
                File selectedFile = chooser.getSelectedFile();
                if (selectedFile == null) {
                    JOptionPane.showMessageDialog(LoginPanel.this, Messages.getString("LoginPanel.33"), Messages.getString("LoginPanel.34"), 0);
                    return;
                }
                if (!selectedFile.canRead()) {
                    JOptionPane.showMessageDialog(LoginPanel.this, Messages.getString("LoginPanel.35"), Messages.getString("LoginPanel.36"), 0);
                    return;
                }
                LoginPanel.importFavourites(selectedFile);
                LoginPanel.this.repaint();
            }
        });
        c.gridx = 2;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 2;
        grid.setConstraints(this.btnImportFavourite, c);
        this.add(this.btnImportFavourite);
        JPanel spacer = new JPanel();
        c.gridx = 2;
        c.gridy = 8;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        grid.setConstraints(spacer, c);
        this.add(spacer);
    }

    public Properties getProperties() {
        this.properties.setProperty("password", new String(this.password.getPassword()));
        this.properties.setProperty("uri", this.cur_url.getText());
        this.properties.setProperty("user", this.username.getText());
        this.properties.setProperty("configuration", this.configuration.getText());
        return this.properties;
    }

    private void selectConfFile(File dir) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(dir);
        if (chooser.showDialog(this, Messages.getString("LoginPanel.37")) == 0) {
            File f = chooser.getSelectedFile();
            this.configuration.setText(f.getAbsolutePath());
        }
    }

    private Favourite[] loadFavourites() {
        Preferences prefs = Preferences.userNodeForPackage(LoginPanel.class);
        Preferences favouritesNode = prefs.node(FAVOURITES_NODE);
        String[] favouriteNodeNames = new String[]{};
        try {
            favouriteNodeNames = favouritesNode.childrenNames();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
        Object[] favourites = new Favourite[favouriteNodeNames.length];
        for (int i = 0; i < favouriteNodeNames.length; ++i) {
            Preferences node = favouritesNode.node(favouriteNodeNames[i]);
            Favourite favourite = new Favourite(favouriteNodeNames[i], node.get(Favourite.USERNAME, ""), node.get(Favourite.PASSWORD, ""), node.get(Favourite.URL, ""), node.get(Favourite.CONFIGURATION, ""));
            favourites[i] = favourite;
        }
        Arrays.sort(favourites);
        return favourites;
    }

    private void storeFavourites(Favourite[] favs) {
        Preferences prefs = Preferences.userNodeForPackage(LoginPanel.class);
        Preferences favouritesNode = prefs.node(FAVOURITES_NODE);
        try {
            favouritesNode.removeNode();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
        favouritesNode = prefs.node(FAVOURITES_NODE);
        for (int i = 0; i < favs.length; ++i) {
            if (favs[i] == null) continue;
            Preferences favouriteNode = favouritesNode.node(favs[i].getName());
            favouriteNode.put(Favourite.USERNAME, favs[i].getUsername());
            favouriteNode.put(Favourite.PASSWORD, favs[i].getPassword());
            favouriteNode.put(Favourite.URL, favs[i].getUrl());
            favouriteNode.put(Favourite.CONFIGURATION, favs[i].getConfiguration());
        }
    }

    private void storeFavourites(ListModel model) {
        Favourite[] favs = new Favourite[model.getSize()];
        for (int i = 0; i < model.getSize(); ++i) {
            favs[i] = (Favourite)model.getElementAt(i);
        }
        this.storeFavourites(favs);
    }

    public static boolean importFavourites(File importFile) {
        boolean importOk = false;
        Preferences prefs = Preferences.userNodeForPackage(LoginPanel.class);
        try {
            FileInputStream fis = new FileInputStream(importFile);
            Preferences.importPreferences(fis);
            importOk = true;
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return importOk;
    }

    public static boolean exportFavourites(File exportFile) {
        boolean exportOk = false;
        Preferences prefs = Preferences.userNodeForPackage(LoginPanel.class);
        try {
            FileOutputStream fos = new FileOutputStream(exportFile);
            prefs.exportSubtree(fos);
            exportOk = true;
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return exportOk;
    }

    static class Favourite
    implements Comparable {
        public static final String NAME = Messages.getString("LoginPanel.42");
        public static final String USERNAME = Messages.getString("LoginPanel.43");
        public static final String PASSWORD = Messages.getString("LoginPanel.44");
        public static final String URL = Messages.getString("LoginPanel.45");
        public static final String CONFIGURATION = Messages.getString("LoginPanel.46");
        private String name;
        private String username;
        private String password;
        private String url;
        private String configuration;

        public Favourite(String name, String username, String password, String url, String configuration) {
            this.name = name;
            this.username = username;
            this.password = password;
            this.url = url;
            this.configuration = configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUrl() {
            return this.url;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public int compareTo(Object o) {
            return this.name.compareTo(o.toString());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return this.name.equals(o.toString());
        }

        public String toString() {
            return this.name;
        }
    }
}

