/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import org.exist.scheduler.JobDescription;
import org.exist.storage.BrokerPool;
import org.exist.storage.SystemTask;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class SystemTaskJob
implements JobDescription,
StatefulJob {
    private String JOB_NAME = "SystemTask";
    private static final String JOB_GROUP = "eXist.System";
    private SystemTask task = null;

    public SystemTaskJob() {
    }

    public SystemTaskJob(SystemTask task) {
        this.task = task;
        this.JOB_NAME = this.JOB_NAME + ": " + task.getClass().getName();
    }

    public final String getName() {
        return this.JOB_NAME;
    }

    public final String getGroup() {
        return JOB_GROUP;
    }

    protected SystemTask getSystemTask() {
        return this.task;
    }

    public final void execute(JobExecutionContext jec) throws JobExecutionException {
        JobDataMap jobDataMap = jec.getJobDetail().getJobDataMap();
        BrokerPool pool = (BrokerPool)jobDataMap.get((Object)"brokerpool");
        SystemTask task = (SystemTask)jobDataMap.get((Object)"systemtask");
        if (pool == null || task == null) {
            JobExecutionException jaa = new JobExecutionException("SystemTaskJob Failed: BrokerPool or SystemTask was null! Unscheduling SystemTask", false);
            jaa.setUnscheduleAllTriggers(true);
            throw jaa;
        }
        pool.triggerSystemTask(task);
    }
}

