/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.source.AbstractSource;
import org.exist.source.ClassLoaderSource;
import org.exist.source.DBSource;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.URLSource;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;

public class SourceFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Source getSource(DBBroker broker, String contextPath, String location, boolean checkXQEncoding) throws MalformedURLException, IOException, PermissionDeniedException {
        AbstractSource source = null;
        if (location.startsWith("file:") || location.indexOf(58) == -1) {
            File f;
            if (location.startsWith("file:")) {
                location = location.substring("file://".length());
            }
            if (!(f = new File(contextPath + File.separatorChar + location)).canRead()) {
                File f2 = new File(location);
                if (!f2.canRead()) {
                    throw new FileNotFoundException("cannot read module source from file at " + location + ". Tried " + f.getAbsolutePath() + " and " + f2.getAbsolutePath());
                }
                f = f2;
            }
            location = f.toURI().toASCIIString();
            source = new FileSource(f, "UTF-8", checkXQEncoding);
        } else if (location.startsWith("xmldb:")) {
            DocumentImpl resource = null;
            try {
                XmldbURI pathUri = XmldbURI.create(location);
                resource = broker.getXMLResource(pathUri, 0);
                source = new DBSource(broker, (BinaryDocument)resource, true);
            }
            finally {
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
            }
        } else if (location.startsWith("resource:")) {
            source = new ClassLoaderSource(location);
        } else {
            URL url = new URL(location);
            source = new URLSource(url);
        }
        return source;
    }
}

