/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.DatabaseStatus;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteDatabaseInstanceManager
implements DatabaseInstanceManager {
    protected XmlRpcClient client;

    public RemoteDatabaseInstanceManager(XmlRpcClient client) {
        this.client = client;
    }

    public void shutdown() throws XMLDBException {
        this.shutdown(0L);
    }

    public void shutdown(long delay) throws XMLDBException {
        Vector<Long> params = new Vector<Long>();
        if (delay > 0L) {
            params.addElement(new Long(delay));
        }
        try {
            this.client.execute("shutdown", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "shutdown failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, "shutdown failed", (Throwable)e);
        }
    }

    public boolean enterServiceMode() throws XMLDBException {
        try {
            this.client.execute("enterServiceMode", new Vector());
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "Failed to switch db to service mode: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, "Failed to switch db to service mode: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void exitServiceMode() throws XMLDBException {
        try {
            this.client.execute("exitServiceMode", new Vector());
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "Failed to switch db to service mode: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, "Failed to switch db to service mode: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getName() throws XMLDBException {
        return "DatabaseInstanceManager";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public boolean isLocalInstance() {
        return false;
    }

    public void setCollection(Collection arg0) throws XMLDBException {
    }

    public String getProperty(String arg0) throws XMLDBException {
        return null;
    }

    public void setProperty(String arg0, String arg1) throws XMLDBException {
    }

    public DatabaseStatus getStatus() throws XMLDBException {
        throw new XMLDBException(2, "this method is not available for remote connections");
    }

    public boolean isXACMLEnabled() throws XMLDBException {
        Vector params = new Vector();
        try {
            Object result = this.client.execute("isXACMLEnabled", params);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new XMLDBException(1, "Invalid return type for remote invocation of 'isXACMLEnabled'");
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, "Error determining if XACML is enabled: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, "Error determining if XACML is enabled: " + e.getMessage(), (Throwable)e);
        }
    }
}

