/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class CastExpression
extends AbstractExpression {
    private Expression expression;
    private int cardinality = 2;
    private final int requiredType;

    public CastExpression(XQueryContext context, Expression expr, int requiredType, int cardinality) {
        super(context);
        this.expression = expr;
        this.requiredType = requiredType;
        this.cardinality = cardinality;
        if (!Type.subTypeOf(this.expression.returnsType(), 20)) {
            this.expression = new Atomize(context, this.expression);
        }
    }

    protected Expression getInnerExpression() {
        return this.expression;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.requiredType == 20 || this.requiredType == 28 && this.expression.returnsType() != 28) {
            throw new XPathException("err:XPST0080: cannot cast to " + Type.getTypeName(this.requiredType));
        }
        if (this.requiredType == 13 || this.expression.returnsType() == 13 || this.requiredType == 14 || this.expression.returnsType() == 14) {
            throw new XPathException("err:XPST0051: cannot cast to " + Type.getTypeName(this.requiredType));
        }
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        if (seq.isEmpty()) {
            if ((this.cardinality & 1) == 0) {
                throw new XPathException(this.getASTNode(), "Type error: empty sequence is not allowed here");
            }
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Item item = seq.itemAt(0);
            if (seq.hasMany() && Type.subTypeOf(this.requiredType, 20)) {
                throw new XPathException(this.getASTNode(), "err:XPTY0004: cardinality error: sequence with more than one item is not allowed here");
            }
            try {
                if (this.requiredType == 24) {
                    if (item.getType() == 24) {
                        result = item.toSequence();
                    } else {
                        if (item.getType() != 20 && !Type.subTypeOf(item.getType(), 22)) throw new XPathException(this.getASTNode(), "Cannot cast " + Type.getTypeName(item.getType()) + " to xs:QName");
                        result = new QNameValue(this.context, item.getStringValue());
                    }
                } else {
                    result = item.convertTo(this.requiredType);
                }
            }
            catch (XPathException e) {
                e.setASTNode(this.getASTNode());
                throw e;
            }
        }
        if (!this.context.getProfiler().isEnabled()) return result;
        this.context.getProfiler().end(this, "", result);
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
        dumper.display(" cast as ");
        dumper.display(Type.getTypeName(this.requiredType));
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.expression.toString());
        result.append(" cast as ");
        result.append(Type.getTypeName(this.requiredType));
        return result.toString();
    }

    public int returnsType() {
        return this.requiredType;
    }

    public int getDependencies() {
        return 3;
    }

    public int getCardinality() {
        return 3;
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitCastExpr(this);
    }
}

