/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DynamicCommentConstructor
extends NodeConstructor {
    private final Expression content;

    public DynamicCommentConstructor(XQueryContext context, Expression contentExpr) {
        super(context);
        this.content = new Atomize(context, contentExpr);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.content.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence contentSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((contentSeq = this.content.eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            this.context.proceed(this, builder);
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = contentSeq.iterate();
            while (i.hasNext()) {
                this.context.proceed(this, builder);
                Item next = i.nextItem();
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(next.toString());
            }
            if (buf.indexOf("--") != -1 || buf.toString().endsWith("-")) {
                throw new XPathException("XQDY0072 '" + buf.toString() + "' is not a valid comment");
            }
            int nodeNr = builder.comment(buf.toString());
            result = builder.getDocument().getNode(nodeNr);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("comment {");
        dumper.startIndent();
        this.content.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("comment {");
        result.append(this.content.toString());
        result.append("} ");
        return result.toString();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.content.resetState(postOptimization);
    }
}

