/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunNormalizeUnicode
extends Function {
    private String normalizationForm = null;
    private Class clazz = null;
    private Field modeField = null;
    private Object modeObject = null;
    private static Integer DUMMY_INTEGER = new Integer(0);
    private Constructor constructor = null;
    private Method method = null;
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("normalize-unicode", "http://www.w3.org/2005/xpath-functions"), "Returns the value of $a normalized according to the normalization form NFC. ", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(23, 2)), new FunctionSignature(new QName("normalize-unicode", "http://www.w3.org/2005/xpath-functions"), "Returns the value of $a normalized according to the normalization criteria for a normalization form identified by the value of $b. ", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2)}, new SequenceType(23, 2))};

    public FunNormalizeUnicode(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence s1;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((s1 = this.getArgument(0).eval(contextSequence)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            String newNormalizationForm = "NFC";
            if (this.getArgumentCount() > 1) {
                newNormalizationForm = this.getArgument(1).eval(contextSequence).getStringValue().toUpperCase().trim();
            }
            if ("".equals(newNormalizationForm)) {
                result = new StringValue(s1.getStringValue());
            } else {
                Object returnedObject = null;
                try {
                    if (this.clazz == null) {
                        this.clazz = Class.forName("com.ibm.icu.text.Normalizer");
                    }
                    if (this.modeField == null || !this.normalizationForm.equals(newNormalizationForm)) {
                        try {
                            this.modeField = this.clazz.getField(newNormalizationForm);
                        }
                        catch (NoSuchFieldException e) {
                            throw new XPathException("err:FOCH0003: unknown normalization form");
                        }
                        this.modeObject = this.modeField.get(null);
                        this.normalizationForm = newNormalizationForm;
                    }
                    if (this.constructor == null) {
                        this.constructor = this.clazz.getConstructor(String.class, this.modeField.getType(), Integer.TYPE);
                    }
                    Object[] args = new Object[]{s1.getStringValue(), this.modeObject, DUMMY_INTEGER};
                    if (this.method == null) {
                        this.method = this.clazz.getMethod("getText", null);
                    }
                    Object instance = this.constructor.newInstance(args);
                    returnedObject = this.method.invoke(instance, null);
                }
                catch (Exception e) {
                    throw new XPathException("Can not find the ICU4J library in the classpath " + e.getMessage());
                }
                result = new StringValue((String)returnedObject);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

