/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.response;

import java.util.Date;
import javax.xml.datatype.Duration;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class SetCookie
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("set-cookie", "http://exist-db.org/xquery/response", "response"), "Set's a HTTP Cookie on the HTTP Response. $a is the cookie name, $b is the cookie value.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(11, 1)), new FunctionSignature(new QName("set-cookie", "http://exist-db.org/xquery/response", "response"), "Set's a HTTP Cookie on the HTTP Response. $a is the cookie name, $b is the cookie value, and $c is the maxAge as xs:duration of the cookie.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(53, 2)}, new SequenceType(11, 1))};

    public SetCookie(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        ResponseModule myModule;
        Variable var;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((var = (myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response")).resolveVariable(ResponseModule.RESPONSE_VAR)) == null || var.getValue() == null) {
            throw new XPathException("Response not set");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException("Variable $response is not bound to a Java object.");
        }
        JavaObjectValue response = (JavaObjectValue)var.getValue().itemAt(0);
        String name = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
        String value = this.getArgument(1).eval(contextSequence, contextItem).getStringValue();
        Sequence ageSeq = this.getArgument(2).eval(contextSequence, contextItem);
        if (response.getObject() instanceof ResponseWrapper) {
            if (ageSeq.isEmpty()) {
                ((ResponseWrapper)response.getObject()).addCookie(name, value);
            } else {
                Duration duration = ((DurationValue)ageSeq.itemAt(0)).getCanonicalDuration();
                int maxAge = (int)(duration.getTimeInMillis(new Date(System.currentTimeMillis())) / 1000L);
                ((ResponseWrapper)response.getObject()).addCookie(name, value, maxAge);
            }
        } else {
            throw new XPathException("Type error: variable $response is not bound to a response object");
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

