/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.StoredNode;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.NodeImpl;
import org.exist.numbering.NodeId;
import org.exist.util.FastQSort;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MixedNodeValueComparator;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class ValueSequence
extends AbstractSequence {
    private final Logger LOG = Logger.getLogger((Class)ValueSequence.class);
    private static final int UNSET_SIZE = -1;
    private static final int INITIAL_SIZE = 64;
    private Item[] values;
    private int size = -1;
    private int itemType = 12;
    private boolean noDuplicates = false;
    private Variable holderVar = null;

    public ValueSequence() {
        this.values = new Item[64];
    }

    public ValueSequence(int initialSize) {
        this.values = new Item[initialSize];
    }

    public ValueSequence(Sequence otherSequence) throws XPathException {
        this.values = new Item[otherSequence.getItemCount()];
        this.addAll(otherSequence);
    }

    public void clear() {
        Arrays.fill(this.values, null);
        this.size = -1;
        this.itemType = 12;
        this.noDuplicates = false;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean hasOne() {
        return this.hasOne;
    }

    public void add(Item item) {
        if (this.hasOne) {
            this.hasOne = false;
        }
        if (this.isEmpty) {
            this.hasOne = true;
        }
        this.isEmpty = false;
        ++this.size;
        this.ensureCapacity();
        this.values[this.size] = item;
        if (this.itemType == item.getType()) {
            return;
        }
        this.itemType = this.itemType == 12 ? item.getType() : Type.getCommonSuperType(item.getType(), this.itemType);
        this.noDuplicates = false;
    }

    public void addAll(Sequence otherSequence) throws XPathException {
        if (otherSequence == null) {
            return;
        }
        SequenceIterator iterator = otherSequence.iterate();
        if (iterator == null) {
            this.LOG.warn((Object)("Iterator == null: " + otherSequence.getClass().getName()));
        }
        while (iterator.hasNext()) {
            this.add(iterator.nextItem());
        }
    }

    public int getItemType() {
        return this.itemType == 12 ? 11 : this.itemType;
    }

    public SequenceIterator iterate() throws XPathException {
        return new ValueSequenceIterator();
    }

    public SequenceIterator unorderedIterator() {
        return new ValueSequenceIterator();
    }

    public int getItemCount() {
        return this.size + 1;
    }

    public Item itemAt(int pos) {
        return this.values[pos];
    }

    public void setHolderVariable(Variable var) {
        this.holderVar = var;
    }

    public NodeSet toNodeSet() throws XPathException {
        if (this.size == -1) {
            return NodeSet.EMPTY_SET;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            ExtArrayNodeSet set = new ExtArrayNodeSet();
            for (int i = 0; i <= this.size; ++i) {
                NodeValue v = (NodeValue)this.values[i];
                if (v.getImplementationType() != 1) {
                    DocumentImpl doc = ((NodeImpl)v).getDocument();
                    if (doc == null) continue;
                    Int2ObjectHashMap newRoots = doc.makePersistent();
                    if (newRoots == null) {
                        return NodeSet.EMPTY_SET;
                    }
                    for (int j = i; j <= this.size; ++j) {
                        NodeProxy p;
                        NodeImpl node;
                        v = (NodeValue)this.values[j];
                        if (v.getImplementationType() == 1 || (node = (NodeImpl)v).getDocument() != doc || (p = (NodeProxy)newRoots.get(node.getNodeNumber())) == null) continue;
                        this.values[j] = p;
                    }
                    set.add((NodeProxy)this.values[i]);
                    continue;
                }
                set.add((NodeProxy)v);
            }
            if (this.holderVar != null) {
                this.holderVar.setValue(set);
            }
            return set;
        }
        throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is " + Type.getTypeName(this.itemType));
    }

    public boolean isPersistentSet() {
        if (this.size == -1) {
            return true;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            for (int i = 0; i <= this.size; ++i) {
                NodeValue v = (NodeValue)this.values[i];
                if (v.getImplementationType() == 1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void sortInDocumentOrder() {
        this.removeDuplicates();
        FastQSort.sort(this.values, new MixedNodeValueComparator(), 0, this.size);
    }

    private void ensureCapacity() {
        if (this.size == this.values.length) {
            int newSize = this.size * 3 / 2;
            Item[] newValues = new Item[newSize];
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.values = newValues;
        }
    }

    public void removeDuplicates() {
        if (this.noDuplicates) {
            return;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, 20)) {
            return;
        }
        boolean hasNodes = false;
        for (int i = 0; i <= this.size; ++i) {
            if (!Type.subTypeOf(this.values[i].getType(), -1)) continue;
            hasNodes = true;
        }
        if (!hasNodes) {
            return;
        }
        TreeSet<Item> nodes = new TreeSet<Item>();
        int j = 0;
        for (int i = 0; i <= this.size; ++i) {
            if (Type.subTypeOf(this.values[i].getType(), -1)) {
                if (nodes.contains(this.values[i])) continue;
                Item item = this.values[i];
                this.values[j++] = item;
                nodes.add(item);
                continue;
            }
            this.values[j++] = this.values[i];
        }
        this.size = j - 1;
        this.noDuplicates = true;
    }

    public void clearContext(int contextId) {
        for (int i = 0; i <= this.size; ++i) {
            if (!Type.subTypeOf(this.values[i].getType(), -1)) continue;
            ((NodeValue)this.values[i]).clearContext(contextId);
        }
    }

    public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
        for (int i = 0; i <= this.size; ++i) {
            this.values[i].nodeMoved(oldNodeId, newNode);
        }
    }

    public DocumentSet getDocumentSet() {
        DocumentSet docs = new DocumentSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeValue node;
            if (!Type.subTypeOf(this.values[i].getType(), -1) || (node = (NodeValue)this.values[i]).getImplementationType() != 1) continue;
            docs.add(node.getOwnerDocument());
        }
        return docs;
    }

    public Iterator getCollectionIterator() {
        return new CollectionIterator();
    }

    public String toString() {
        try {
            StringBuffer result = new StringBuffer();
            result.append("(");
            boolean moreThanOne = false;
            SequenceIterator i = this.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (moreThanOne) {
                    result.append(", ");
                }
                moreThanOne = true;
                result.append(next.toString());
            }
            result.append(")");
            return result.toString();
        }
        catch (XPathException e) {
            return "ValueSequence.toString() failed: " + e.getMessage();
        }
    }

    public String getHashKey() {
        try {
            String hashKey = "";
            SequenceIterator i = this.iterate();
            while (i.hasNext()) {
                Item current = i.nextItem();
                hashKey = hashKey + current.getStringValue();
                hashKey = hashKey + "&&";
            }
            return hashKey;
        }
        catch (XPathException e) {
            return "ValueSequence.getHashKey() failed: " + e.getMessage();
        }
    }

    private class ValueSequenceIterator
    implements SequenceIterator {
        private int pos = 0;

        public boolean hasNext() {
            return this.pos <= ValueSequence.this.size;
        }

        public Item nextItem() {
            if (this.pos <= ValueSequence.this.size) {
                return ValueSequence.this.values[this.pos++];
            }
            return null;
        }
    }

    private class CollectionIterator
    implements Iterator {
        Collection nextCollection = (Collection)this.next();
        int pos = 0;

        CollectionIterator() {
        }

        public boolean hasNext() {
            return this.nextCollection != null;
        }

        public Object next() {
            Collection oldCollection = this.nextCollection;
            this.nextCollection = null;
            while (this.pos <= ValueSequence.this.size) {
                NodeProxy p;
                NodeValue node;
                if (Type.subTypeOf(ValueSequence.this.values[this.pos].getType(), -1) && (node = (NodeValue)ValueSequence.this.values[this.pos]).getImplementationType() == 1 && !(p = (NodeProxy)node).getDocument().getCollection().equals(oldCollection)) {
                    this.nextCollection = p.getDocument().getCollection();
                    break;
                }
                ++this.pos;
            }
            return oldCollection;
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }
}

