/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.ComplexFileTable;
import org.textmining.extraction.word.PasswordProtectedException;
import org.textmining.extraction.word.WordTextExtractor;
import org.textmining.extraction.word.WordTextScrubber;
import org.textmining.extraction.word.chp.Word6CHPBinTable;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.ComplexNodeHelper;
import org.textmining.extraction.word.model.NodeHelper;
import org.textmining.extraction.word.model.PieceDescriptor;
import org.textmining.extraction.word.model.TextPiece;
import org.textmining.extraction.word.model.TextPieceTable;

public class Word6TextExtractor
extends WordTextExtractor {
    Word6TextExtractor(byte[] byArray, boolean bl) {
        this._header = byArray;
        this._fastSave = bl;
    }

    protected Word6TextExtractor() {
    }

    public Word6TextExtractor(InputStream inputStream) throws IOException, PasswordProtectedException {
        super.initWordHeader(inputStream);
    }

    protected boolean isDeleted(byte[] byArray) {
        int n = 0;
        boolean bl = false;
        while (n < byArray.length) {
            switch (LittleEndian.getUnsignedByte((byte[])byArray, (int)n++)) {
                case 65: {
                    bl = byArray[n++] != 0;
                    break;
                }
                case 66: {
                    ++n;
                    break;
                }
                case 67: {
                    ++n;
                    break;
                }
                case 68: {
                    n += byArray[n];
                    break;
                }
                case 69: {
                    n += 2;
                    break;
                }
                case 70: {
                    n += 4;
                    break;
                }
                case 71: {
                    ++n;
                    break;
                }
                case 72: {
                    n += 2;
                    break;
                }
                case 73: {
                    n += 3;
                    break;
                }
                case 74: {
                    n += byArray[n];
                    break;
                }
                case 75: {
                    ++n;
                    break;
                }
                case 80: {
                    n += 2;
                    break;
                }
                case 81: {
                    n += byArray[n];
                    break;
                }
                case 82: {
                    n += byArray[n];
                    break;
                }
                case 83: {
                    break;
                }
                case 85: {
                    ++n;
                    break;
                }
                case 86: {
                    ++n;
                    break;
                }
                case 87: {
                    ++n;
                    break;
                }
                case 88: {
                    ++n;
                    break;
                }
                case 89: {
                    ++n;
                    break;
                }
                case 90: {
                    ++n;
                    break;
                }
                case 91: {
                    ++n;
                    break;
                }
                case 92: {
                    ++n;
                    break;
                }
                case 93: {
                    n += 2;
                    break;
                }
                case 94: {
                    ++n;
                    break;
                }
                case 95: {
                    n += 3;
                    break;
                }
                case 96: {
                    n += 2;
                    break;
                }
                case 97: {
                    n += 2;
                    break;
                }
                case 98: {
                    ++n;
                    break;
                }
                case 99: {
                    ++n;
                    break;
                }
                case 100: {
                    ++n;
                    break;
                }
                case 101: {
                    ++n;
                    break;
                }
                case 102: {
                    ++n;
                    break;
                }
                case 103: {
                    n += byArray[n];
                    break;
                }
                case 104: {
                    ++n;
                    break;
                }
                case 105: {
                    n += byArray[n];
                    break;
                }
                case 106: {
                    n += byArray[n];
                    break;
                }
                case 107: {
                    n += 2;
                    break;
                }
                case 108: {
                    n += byArray[n];
                    break;
                }
                case 109: {
                    n += 2;
                    break;
                }
                case 110: {
                    n += 2;
                    break;
                }
                case 117: {
                    ++n;
                    break;
                }
                case 118: {
                    ++n;
                }
            }
        }
        return bl;
    }

    public String getText() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.getText(stringWriter);
        return stringWriter.toString();
    }

    public void getText(Writer writer) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n = LittleEndian.getInt((byte[])this._header, (int)24);
        int n2 = LittleEndian.getInt((byte[])this._header, (int)28);
        int n3 = this.getChpTableOffset();
        int n4 = this.getChpTableSize();
        NodeHelper nodeHelper = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._fastSave) {
            int n5 = this.getComplexOffset();
            object3 = new ComplexFileTable(this._header, this._header, n5, n);
            object2 = ((ComplexFileTable)object3).getTextPieceTable();
            nodeHelper = new ComplexNodeHelper((TextPieceTable)object2);
            List list = ((TextPieceTable)object2).getTextPieces();
            for (int i = 0; i < list.size(); ++i) {
                object = (TextPiece)list.get(i);
                ((TextPiece)object).getPieceDescriptor().setUnicode(false);
                String string = ((TextPiece)object).getText(this._header);
                stringBuffer.append(string);
            }
        } else {
            PieceDescriptor pieceDescriptor = new PieceDescriptor();
            pieceDescriptor.setFilePosition(n);
            object3 = new TextPieceTable();
            object2 = new TextPiece(0, n2 - n, pieceDescriptor);
            ((TextPieceTable)object3).getTextPieces().add(object2);
            nodeHelper = new NodeHelper((TextPieceTable)object3);
            stringBuffer.append(((TextPiece)object2).getText(this._header));
        }
        Word6CHPBinTable word6CHPBinTable = new Word6CHPBinTable(this._header, n3, n4, n, nodeHelper);
        object3 = word6CHPBinTable.getTextRuns();
        object2 = new WordTextScrubber();
        for (int i = 0; i < object3.size(); ++i) {
            CHPX cHPX = (CHPX)object3.get(i);
            if (this.isDeleted(cHPX.getGrpprl())) continue;
            object = stringBuffer.substring(cHPX.getStart(), cHPX.getEnd());
            ((WordTextScrubber)object2).append(writer, (String)object);
        }
    }

    protected int getChpTableSize() {
        return LittleEndian.getInt((byte[])this._header, (int)188);
    }

    protected int getChpTableOffset() {
        return LittleEndian.getInt((byte[])this._header, (int)184);
    }

    protected int getComplexOffset() {
        return LittleEndian.getInt((byte[])this._header, (int)352);
    }
}

