/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.TextExtractor;
import org.textmining.extraction.word.PasswordProtectedException;
import org.textmining.extraction.word.WordTextScrubber;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.PieceDescriptor;
import org.textmining.extraction.word.model.TextPiece;

public abstract class WordTextExtractor
implements TextExtractor {
    protected byte[] _header;
    protected boolean _fastSave;
    protected POIFSFileSystem _fsys;

    protected void doFastSaveExtraction(Writer writer, int n, List list, List list2, WordTextScrubber wordTextScrubber) throws UnsupportedEncodingException, IOException {
        for (int i = 0; i < list.size(); ++i) {
            TextPiece textPiece = (TextPiece)list.get(i);
            PieceDescriptor pieceDescriptor = textPiece.getPieceDescriptor();
            int n2 = pieceDescriptor.getFilePosition();
            int n3 = n2 + (textPiece.getEnd() - textPiece.getStart()) * (pieceDescriptor.isUnicode() && this.supportsUnicode() ? 2 : 1);
            for (int j = 0; j < list2.size(); ++j) {
                CHPX cHPX = (CHPX)list2.get(j);
                int n4 = cHPX.getStart() + n;
                int n5 = cHPX.getEnd() + n;
                if (n4 < n2 && n5 <= n2 || n4 >= n3 && n5 > n3 || this.isDeleted(cHPX.getGrpprl())) continue;
                int n6 = Math.max(n4, n2);
                int n7 = Math.min(n5, n3);
                String string = new String(this._header, n6, n7 - n6, pieceDescriptor.isUnicode() && this.supportsUnicode() ? "UTF-16LE" : "Cp1252");
                wordTextScrubber.append(writer, string);
            }
        }
    }

    protected abstract boolean isDeleted(byte[] var1);

    protected boolean supportsUnicode() {
        return false;
    }

    protected void initWordHeader(InputStream inputStream) throws IOException, PasswordProtectedException {
        this._fsys = new POIFSFileSystem(inputStream);
        DocumentEntry documentEntry = (DocumentEntry)this._fsys.getRoot().getEntry("WordDocument");
        DocumentInputStream documentInputStream = this._fsys.createDocumentInputStream("WordDocument");
        this._header = new byte[documentEntry.getSize()];
        documentInputStream.read(this._header);
        documentInputStream.close();
        this.initOptions();
    }

    protected void initOptions() throws PasswordProtectedException {
        short s = LittleEndian.getShort((byte[])this._header, (int)10);
        boolean bl = this._fastSave = (s & 4) != 0;
        if ((s & 0x100) != 0) {
            throw new PasswordProtectedException("This document is password protected");
        }
    }
}

