/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.dbxml.XmlException;

public class XmlHelper {
    public static DbEnv getDbEnv(Environment env) throws XmlException {
        try {
            env.getHome();
        }
        catch (DatabaseException e) {
            throw new XmlException(5, "Invalid Environment object, may be closed.", e, e.getErrno());
        }
        catch (Exception e) {
            throw new XmlException(5, "Invalid Environment object, may be closed.", new DatabaseException("Invalid environment."), 0);
        }
        return env.unwrap();
    }

    public static DbTxn getDbTxn(Transaction txn) {
        return txn.txn;
    }

    public static Environment makeNewEnvironment(DbEnv env) throws DatabaseException {
        return new Environment(env);
    }

    public static int getFlag(LockMode mode) throws DatabaseException {
        return LockMode.getFlag((LockMode)mode);
    }
}

