/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.dbxml;

import com.sleepycat.db.DatabaseConfig;

public class XmlContainerConfig
extends DatabaseConfig {
    public static final XmlContainerConfig DEFAULT = new XmlContainerConfig();
    private int indexNodesFlag = 0;
    private int statisticsFlag = 0;
    private boolean nodeContainer = true;
    private boolean allowValidation = false;

    public boolean getIndexNodes() {
        if (this.indexNodesFlag != 0) {
            return (this.indexNodesFlag & 0x1000000) != 0;
        }
        return this.nodeContainer;
    }

    public XmlContainerConfig setIndexNodes(boolean value) {
        this.indexNodesFlag = value ? 0x1000000 : 65536;
        return this;
    }

    public boolean getStatisticsEnabled() {
        return (this.statisticsFlag & 0x2000000) != 0;
    }

    public XmlContainerConfig setStatisticsEnabled(boolean value) {
        this.statisticsFlag = value ? 0x2000000 : 0x4000000;
        return this;
    }

    public boolean getNodeContainer() {
        return this.nodeContainer;
    }

    public XmlContainerConfig setNodeContainer(boolean value) {
        this.nodeContainer = value;
        return this;
    }

    public boolean getAllowValidation() {
        return this.allowValidation;
    }

    public XmlContainerConfig setAllowValidation(boolean value) {
        this.allowValidation = value;
        return this;
    }

    int makeFlags(boolean threaded) {
        int flags = 0;
        if (this.indexNodesFlag != 0) {
            flags |= this.indexNodesFlag;
        }
        if (this.statisticsFlag != 0) {
            flags |= this.statisticsFlag;
        }
        if (this.getChecksum()) {
            flags |= 0x400000;
        }
        if (this.getEncrypted()) {
            flags |= 0x800000;
        }
        if (this.getTransactional()) {
            flags |= 0x200000;
        }
        if (this.getAllowValidation()) {
            flags |= 0x100000;
        }
        if (this.getAllowCreate()) {
            flags |= 1;
        }
        if (this.getExclusiveCreate()) {
            flags |= 0x4000;
        }
        if (this.getNoMMap()) {
            flags |= 0x10;
        }
        if (this.getReadOnly()) {
            flags |= 0x20;
        }
        if (this.getMultiversion()) {
            flags |= 8;
        }
        if (this.getReadUncommitted()) {
            flags |= 0x8000000;
        }
        if (threaded) {
            flags |= 0x80;
        }
        if (this.getTransactionNotDurable()) {
            flags |= 0x800;
        }
        return flags;
    }
}

