/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

class CQLLexer
extends StreamTokenizer {
    static int TT_LE = 1000;
    static int TT_GE = 1001;
    static int TT_NE = 1002;
    static int TT_AND = 1003;
    static int TT_OR = 1004;
    static int TT_NOT = 1005;
    static int TT_PROX = 1006;
    static int TT_ANY = 1007;
    static int TT_ALL = 1008;
    static int TT_EXACT = 1009;
    static int TT_pWORD = 1010;
    static int TT_SENTENCE = 1011;
    static int TT_PARAGRAPH = 1012;
    static int TT_ELEMENT = 1013;
    static int TT_ORDERED = 1014;
    static int TT_UNORDERED = 1015;
    static int TT_RELEVANT = 1016;
    static int TT_FUZZY = 1017;
    static int TT_STEM = 1018;
    static int TT_SCR = 1019;
    static int TT_PHONETIC = 1020;
    private static int TT_UNDEFINED = -1000;
    private static boolean DEBUG;
    private Keyword[] keywords = new Keyword[]{new Keyword(TT_AND, "and"), new Keyword(TT_OR, "or"), new Keyword(TT_NOT, "not"), new Keyword(TT_PROX, "prox"), new Keyword(TT_ANY, "any"), new Keyword(TT_ALL, "all"), new Keyword(TT_EXACT, "exact"), new Keyword(TT_pWORD, "word"), new Keyword(TT_SENTENCE, "sentence"), new Keyword(TT_PARAGRAPH, "paragraph"), new Keyword(TT_ELEMENT, "element"), new Keyword(TT_ORDERED, "ordered"), new Keyword(TT_UNORDERED, "unordered"), new Keyword(TT_RELEVANT, "relevant"), new Keyword(TT_FUZZY, "fuzzy"), new Keyword(TT_STEM, "stem"), new Keyword(TT_SCR, "scr"), new Keyword(TT_PHONETIC, "phonetic")};
    private int saved_ttype = TT_UNDEFINED;
    private double saved_nval;
    private String saved_sval;

    private static final void debug(String string) {
        if (DEBUG) {
            System.err.println("LEXDEBUG: " + string);
        }
    }

    private final void halfDecentPushBack() {
        this.saved_ttype = this.ttype;
        this.saved_nval = this.nval;
        this.saved_sval = this.sval;
    }

    public int nextToken() throws IOException {
        if (this.saved_ttype != TT_UNDEFINED) {
            this.ttype = this.saved_ttype;
            this.nval = this.saved_nval;
            this.sval = this.saved_sval;
            this.saved_ttype = TT_UNDEFINED;
            CQLLexer.debug("using saved ttype=" + this.ttype + ", " + "nval=" + this.nval + ", sval='" + this.sval + "'");
            return this.ttype;
        }
        this.underlyingNextToken();
        if (this.ttype == 60) {
            CQLLexer.debug("token starts with '<' ...");
            this.underlyingNextToken();
            if (this.ttype == 61) {
                CQLLexer.debug("token continues with '=' - it's '<='");
                this.ttype = TT_LE;
            } else if (this.ttype == 62) {
                CQLLexer.debug("token continues with '>' - it's '<>'");
                this.ttype = TT_NE;
            } else {
                CQLLexer.debug("next token is " + this.render() + " (pushed back)");
                this.halfDecentPushBack();
                this.ttype = 60;
                CQLLexer.debug("AFTER: ttype is now " + this.ttype + " - " + this.render());
            }
        } else if (this.ttype == 62) {
            CQLLexer.debug("token starts with '>' ...");
            this.underlyingNextToken();
            if (this.ttype == 61) {
                CQLLexer.debug("token continues with '=' - it's '>='");
                this.ttype = TT_GE;
            } else {
                CQLLexer.debug("next token is " + this.render() + " (pushed back)");
                this.halfDecentPushBack();
                this.ttype = 62;
                CQLLexer.debug("AFTER: ttype is now " + this.ttype + " - " + this.render());
            }
        }
        CQLLexer.debug("done nextToken(): ttype=" + this.ttype + ", " + "nval=" + this.nval + ", " + "sval='" + this.sval + "'" + " (" + this.render() + ")");
        return this.ttype;
    }

    public int underlyingNextToken() throws IOException {
        super.nextToken();
        if (this.ttype == -3) {
            int n = 0;
            while (n < this.keywords.length) {
                if (this.sval.equalsIgnoreCase(this.keywords[n].keyword)) {
                    this.ttype = this.keywords[n].token;
                }
                ++n;
            }
        }
        return this.ttype;
    }

    String render() {
        return this.render(this.ttype, true);
    }

    String render(int n, boolean bl) {
        if (n == -1) {
            return "EOF";
        }
        if (n == -2) {
            return new Integer((int)this.nval).toString();
        }
        if (n == -3) {
            return "word: " + this.sval;
        }
        if (n == 34) {
            return "string: \"" + this.sval + "\"";
        }
        if (n == TT_LE) {
            return "<=";
        }
        if (n == TT_GE) {
            return ">=";
        }
        if (n == TT_NE) {
            return "<>";
        }
        int n2 = 0;
        while (n2 < this.keywords.length) {
            if (n == this.keywords[n2].token) {
                return this.keywords[n2].keyword;
            }
            ++n2;
        }
        String string = String.valueOf((char)n);
        if (bl) {
            string = "'" + string + "'";
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Object object;
        String string;
        if (stringArray.length > 1) {
            System.err.println("Usage: CQLLexer [<CQL-query>]");
            System.err.println("If unspecified, query is read from stdin");
            System.exit(1);
        }
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            object = new byte[10000];
            try {
                n = System.in.read((byte[])object);
            }
            catch (IOException iOException) {
                System.err.println("Can't read query: " + iOException.getMessage());
                System.exit(2);
            }
            string = new String((byte[])object);
        }
        object = new CQLLexer(string, true);
        while ((n = ((CQLLexer)object).nextToken()) != -1) {
        }
    }

    CQLLexer(String string, boolean bl) {
        super(new StringReader(string));
        this.wordChars(33, 63);
        this.wordChars(91, 96);
        this.quoteChar(34);
        this.ordinaryChar(61);
        this.ordinaryChar(60);
        this.ordinaryChar(62);
        this.ordinaryChar(47);
        this.ordinaryChar(40);
        this.ordinaryChar(41);
        this.wordChars(39, 39);
        this.parseNumbers();
        DEBUG = bl;
    }

    private class Keyword {
        int token;
        String keyword;

        Keyword(int n, String string) {
            this.token = n;
            this.keyword = string;
        }
    }
}

