/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class Minimax
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;
    private boolean ignoreNaN = false;

    public void setIgnoreNaN(boolean bl) {
        this.ignoreNaN = bl;
    }

    public boolean isIgnoreNaN() {
        return this.ignoreNaN;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], false);
    }

    public int computeCardinality() {
        int n = super.computeCardinality();
        if (!Cardinality.allowsZero(this.argument[0].getCardinality())) {
            n = 16384;
        }
        return n;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        if (expression != this) {
            return expression;
        }
        if (this.getNumberOfArguments() == 1) {
            int n = this.argument[0].getCardinality();
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            if (!Cardinality.allowsMany(n) && typeHierarchy.isSubType(this.argument[0].getItemType(typeHierarchy), BuiltInAtomicType.NUMERIC)) {
                Expression.setParentExpression(this.argument[0], this.getParentExpression());
                return this.argument[0];
            }
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType = this.argument[0].getItemType(typeHierarchy);
        if (itemType.getPrimitiveType() == 631) {
            return BuiltInAtomicType.DOUBLE;
        }
        return itemType;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        GenericAtomicComparer genericAtomicComparer = this.getAtomicComparer(1, xPathContext);
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        try {
            return Minimax.minimax(sequenceIterator, this.operation, genericAtomicComparer, this.ignoreNaN, xPathContext);
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(this);
            throw xPathException;
        }
    }

    public static AtomicValue minimax(SequenceIterator sequenceIterator, int n, AtomicComparer atomicComparer, boolean bl, XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        AtomicValue atomicValue2;
        AtomicValue atomicValue3;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        TypeHierarchy typeHierarchy;
        block32: {
            block31: {
                typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
                bl4 = false;
                bl3 = false;
                bl2 = false;
                if (n == 3) {
                    atomicComparer = new DescendingComparer(atomicComparer);
                }
                do {
                    if ((atomicValue3 = (AtomicValue)sequenceIterator.next()) == null) {
                        return null;
                    }
                    atomicValue2 = atomicValue3;
                    if (atomicValue3 instanceof UntypedAtomicValue) {
                        try {
                            atomicValue2 = atomicValue3 = new DoubleValue(Value.stringToNumber(atomicValue3.getStringValueCS()));
                            bl4 = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            DynamicError dynamicError = new DynamicError("Failure converting " + Err.wrap(atomicValue3.getStringValueCS()) + " to a number");
                            dynamicError.setErrorCode("FORG0001");
                            dynamicError.setXPathContext(xPathContext);
                            throw dynamicError;
                        }
                    } else if (atomicValue2 instanceof DoubleValue) {
                        bl4 = true;
                    } else if (atomicValue2 instanceof FloatValue) {
                        bl3 = true;
                    }
                    if (!(atomicValue2 instanceof NumericValue) || !((NumericValue)atomicValue2).isNaN()) break block31;
                } while (bl);
                if (atomicValue2 instanceof DoubleValue) {
                    return atomicValue3;
                }
                bl2 = true;
                atomicValue3 = FloatValue.NaN;
                break block32;
            }
            if (!atomicValue2.getPrimitiveType().isOrdered()) {
                DynamicError dynamicError = new DynamicError("Type " + atomicValue2.getPrimitiveType() + " is not an ordered type");
                dynamicError.setErrorCode("FORG0006");
                dynamicError.setIsTypeError(true);
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
        }
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            AtomicValue atomicValue4;
            atomicValue2 = atomicValue4 = atomicValue;
            if (atomicValue instanceof UntypedAtomicValue) {
                try {
                    atomicValue4 = new DoubleValue(Value.stringToNumber(atomicValue.getStringValueCS()));
                    if (bl2) {
                        return DoubleValue.NaN;
                    }
                    atomicValue2 = atomicValue4;
                    bl4 = true;
                }
                catch (NumberFormatException numberFormatException) {
                    DynamicError dynamicError = new DynamicError("Failure converting " + Err.wrap(atomicValue.getStringValueCS()) + " to a number");
                    dynamicError.setErrorCode("FORG0001");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            } else if (atomicValue2 instanceof DoubleValue) {
                if (bl2) {
                    return DoubleValue.NaN;
                }
                bl4 = true;
            } else if (atomicValue2 instanceof FloatValue) {
                bl3 = true;
            }
            if (atomicValue2 instanceof NumericValue && ((NumericValue)atomicValue2).isNaN()) {
                if (bl) continue;
                if (bl4) {
                    return DoubleValue.NaN;
                }
                bl2 = true;
                continue;
            }
            try {
                if (atomicComparer.compareAtomicValues(atomicValue2, atomicValue3) >= 0) continue;
                atomicValue3 = atomicValue4;
            }
            catch (ClassCastException classCastException) {
                DynamicError dynamicError = new DynamicError("Cannot compare " + atomicValue3.getItemType(typeHierarchy) + " with " + atomicValue4.getItemType(typeHierarchy));
                dynamicError.setErrorCode("FORG0006");
                dynamicError.setIsTypeError(true);
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
        }
        if (bl2) {
            return FloatValue.NaN;
        }
        if (bl4) {
            if (!(atomicValue3 instanceof DoubleValue)) {
                atomicValue3 = atomicValue3.convert(BuiltInAtomicType.DOUBLE, xPathContext);
            }
        } else if (bl3 && !(atomicValue3 instanceof FloatValue)) {
            atomicValue3 = atomicValue3.convert(BuiltInAtomicType.FLOAT, xPathContext);
        }
        return atomicValue3;
    }
}

