/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.chunk;

import org.apache.lucene.chunk.Chunk;
import org.apache.lucene.mark.MarkPos;

public class ChunkMarkPos
extends MarkPos {
    protected int wordPos;
    protected int charPos;
    protected Chunk chunk;

    public int wordPos() {
        return this.wordPos;
    }

    public int countTextTo(MarkPos other) {
        ChunkMarkPos cm = (ChunkMarkPos)other;
        if (other == null) {
            return this.chunk.text.length() - this.charPos;
        }
        if (this.chunk == cm.chunk) {
            return cm.charPos - this.charPos;
        }
        if (this.chunk.chunkNum > cm.chunk.chunkNum) {
            assert (false);
            throw new RuntimeException("Cannot countTextTo() backward position");
        }
        int count = this.chunk.text.length() - this.charPos;
        int i = this.chunk.chunkNum + 1;
        while (i < cm.chunk.chunkNum) {
            count += this.chunk.source.loadChunk((int)i).text.length();
            ++i;
        }
        return count += cm.charPos;
    }

    public String getTextTo(MarkPos other) {
        ChunkMarkPos cm = (ChunkMarkPos)other;
        if (other == null) {
            return this.chunk.text.substring(this.charPos);
        }
        if (this.chunk.chunkNum == cm.chunk.chunkNum) {
            assert (this.charPos <= cm.charPos) : "Cannot getTextTo() backward position";
            return this.chunk.text.substring(this.charPos, cm.charPos);
        }
        if (this.chunk.chunkNum > cm.chunk.chunkNum) {
            assert (false);
            throw new RuntimeException("Cannot getTextTo() backward position");
        }
        if (cm.chunk.chunkNum - this.chunk.chunkNum > 2) assert (false) : "getText spanning many chunks is probably a logic error";
        StringBuffer buf = new StringBuffer();
        buf.append(this.chunk.text.substring(this.charPos));
        int i = this.chunk.chunkNum + 1;
        while (i < cm.chunk.chunkNum) {
            buf.append(this.chunk.source.loadChunk((int)i).text);
            ++i;
        }
        buf.append(cm.chunk.text.substring(0, cm.charPos));
        return buf.toString();
    }
}

