/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Vector;
import org.apache.lucene.chunk.SpanChunkedNotQuery;
import org.apache.lucene.chunk.SpanDechunkingQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanOrNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanRangeQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWildcardQuery;

public abstract class QueryRewriter {
    public Query rewriteQuery(Query q) {
        if (q instanceof BooleanQuery) {
            return this.rewrite((BooleanQuery)q);
        }
        if (q instanceof SpanNearQuery) {
            return this.rewrite((SpanNearQuery)q);
        }
        if (q instanceof SpanOrQuery) {
            return this.rewrite((SpanOrQuery)q);
        }
        if (q instanceof SpanOrNearQuery) {
            return this.rewrite((SpanOrNearQuery)q);
        }
        if (q instanceof SpanChunkedNotQuery) {
            return this.rewrite((SpanChunkedNotQuery)q);
        }
        if (q instanceof SpanNotQuery) {
            return this.rewrite((SpanNotQuery)q);
        }
        if (q instanceof SpanNotNearQuery) {
            return this.rewrite((SpanNotNearQuery)q);
        }
        if (q instanceof SpanDechunkingQuery) {
            return this.rewrite((SpanDechunkingQuery)q);
        }
        if (q instanceof TermQuery) {
            return this.rewrite((TermQuery)q);
        }
        if (q instanceof SpanWildcardQuery) {
            return this.rewrite((SpanWildcardQuery)q);
        }
        if (q instanceof SpanTermQuery) {
            return this.rewrite((SpanTermQuery)q);
        }
        if (q instanceof SpanRangeQuery) {
            return this.rewrite((SpanRangeQuery)q);
        }
        assert (false) : "Unsupported query type for rewriting: " + q.getClass().getName();
        return null;
    }

    public boolean forceRewrite(Query q) {
        return false;
    }

    protected Query rewrite(BooleanQuery bq) {
        BooleanClause clause;
        Vector<BooleanClause> newClauses = new Vector<BooleanClause>();
        BooleanClause[] clauses = bq.getClauses();
        boolean anyChange = false;
        int i = 0;
        while (i < clauses.length) {
            Query rewrittenQuery = this.rewriteQuery(clauses[i].getQuery());
            if (rewrittenQuery != clauses[i].getQuery()) {
                anyChange = true;
                if (rewrittenQuery != null) {
                    newClauses.add(new BooleanClause(rewrittenQuery, clauses[i].getOccur()));
                }
            } else {
                newClauses.add(clauses[i]);
            }
            ++i;
        }
        boolean force = this.forceRewrite(bq);
        if (!anyChange && !force) {
            return bq;
        }
        if (newClauses.isEmpty()) {
            return null;
        }
        if (newClauses.size() == 1 && !force && (clause = (BooleanClause)newClauses.elementAt(0)).getOccur() == BooleanClause.Occur.MUST_NOT) {
            return this.combineBoost(bq, clause.getQuery());
        }
        bq = (BooleanQuery)this.copyBoost(bq, new BooleanQuery(bq.isCoordDisabled()));
        int i2 = 0;
        while (i2 < newClauses.size()) {
            bq.add((BooleanClause)newClauses.elementAt(i2));
            ++i2;
        }
        return bq;
    }

    protected Query rewrite(final SpanNearQuery q) {
        return this.rewriteClauses(q, q.getClauses(), true, new SpanClauseJoiner(){

            public SpanQuery join(SpanQuery[] clauses) {
                return new SpanNearQuery(clauses, q.getSlop(), q.isInOrder());
            }
        });
    }

    protected Query rewrite(final SpanOrNearQuery q) {
        return this.rewriteClauses(q, q.getClauses(), true, new SpanClauseJoiner(){

            public SpanQuery join(SpanQuery[] clauses) {
                return new SpanOrNearQuery(clauses, q.getSlop(), q.penalizeOutOfOrder());
            }
        });
    }

    protected Query rewrite(SpanOrQuery q) {
        return this.rewriteClauses(q, q.getClauses(), true, new SpanClauseJoiner(){

            public SpanQuery join(SpanQuery[] clauses) {
                return new SpanOrQuery(clauses);
            }
        });
    }

    protected Query rewrite(SpanChunkedNotQuery nq) {
        SpanQuery include = (SpanQuery)this.rewriteQuery(nq.getInclude());
        SpanQuery exclude = (SpanQuery)this.rewriteQuery(nq.getExclude());
        if (include == nq.getInclude() && exclude == nq.getExclude() && !this.forceRewrite(nq)) {
            return nq;
        }
        SpanChunkedNotQuery newq = new SpanChunkedNotQuery(include, exclude, nq.getSlop());
        this.copyBoost(nq, newq);
        return newq;
    }

    protected Query rewrite(SpanNotQuery nq) {
        SpanQuery include = (SpanQuery)this.rewriteQuery(nq.getInclude());
        SpanQuery exclude = (SpanQuery)this.rewriteQuery(nq.getExclude());
        if (include == nq.getInclude() && exclude == nq.getExclude() && !this.forceRewrite(nq)) {
            return nq;
        }
        SpanNotQuery newq = new SpanNotQuery(include, exclude);
        this.copyBoost(nq, newq);
        return newq;
    }

    protected Query rewrite(SpanNotNearQuery nq) {
        SpanQuery include = (SpanQuery)this.rewriteQuery(nq.getInclude());
        SpanQuery exclude = (SpanQuery)this.rewriteQuery(nq.getExclude());
        if (include == nq.getInclude() && exclude == nq.getExclude() && !this.forceRewrite(nq)) {
            return nq;
        }
        SpanNotNearQuery newq = new SpanNotNearQuery(include, exclude, nq.getSlop());
        this.copyBoost(nq, newq);
        return newq;
    }

    protected Query rewrite(SpanDechunkingQuery nq) {
        SpanQuery sub = (SpanQuery)this.rewriteQuery(nq.getWrapped());
        if (sub == nq.getWrapped() && !this.forceRewrite(nq)) {
            return nq;
        }
        if (sub == null) {
            return null;
        }
        SpanDechunkingQuery newq = new SpanDechunkingQuery(sub);
        this.copyBoost(nq, newq);
        return newq;
    }

    protected Query rewrite(TermQuery q) {
        return q;
    }

    protected Query rewrite(SpanTermQuery q) {
        return this.forceRewrite(q) ? (Query)q.clone() : q;
    }

    protected Query rewrite(SpanWildcardQuery q) {
        return this.forceRewrite(q) ? (Query)q.clone() : q;
    }

    protected Query rewrite(SpanRangeQuery q) {
        return this.forceRewrite(q) ? (Query)q.clone() : q;
    }

    protected Query copyBoost(Query oldQuery, Query newQuery) {
        newQuery.setBoost(oldQuery.getBoost());
        if (newQuery instanceof SpanQuery && oldQuery instanceof SpanQuery) {
            ((SpanQuery)newQuery).setSpanRecording(((SpanQuery)oldQuery).getSpanRecording());
        }
        return newQuery;
    }

    protected Query copyBoost(Query oldQuery1, Query oldQuery2, Query newQuery) {
        newQuery.setBoost(Math.max(oldQuery1.getBoost(), oldQuery2.getBoost()));
        if (newQuery instanceof SpanQuery) {
            ((SpanQuery)newQuery).setSpanRecording(Math.max(((SpanQuery)oldQuery1).getSpanRecording(), ((SpanQuery)oldQuery2).getSpanRecording()));
        }
        return newQuery;
    }

    protected Query combineBoost(Query oldQuery, Query newQuery) {
        newQuery.setBoost(oldQuery.getBoost() * newQuery.getBoost());
        if (newQuery instanceof SpanQuery && oldQuery instanceof SpanQuery) {
            ((SpanQuery)newQuery).setSpanRecording(Math.max(((SpanQuery)oldQuery).getSpanRecording(), ((SpanQuery)newQuery).getSpanRecording()));
        }
        return newQuery;
    }

    protected Query rewriteClauses(Query oldQuery, SpanQuery[] oldClauses, boolean promoteSingle, SpanClauseJoiner joiner) {
        Vector<SpanQuery> newClauses = new Vector<SpanQuery>();
        boolean anyChanges = false;
        int i = 0;
        while (i < oldClauses.length) {
            SpanQuery clause = (SpanQuery)this.rewriteQuery(oldClauses[i]);
            if (clause != oldClauses[i]) {
                anyChanges = true;
            }
            if (clause != null) {
                newClauses.add(clause);
            }
            ++i;
        }
        boolean force = this.forceRewrite(oldQuery);
        if (!anyChanges && !force) {
            return oldQuery;
        }
        if (newClauses.isEmpty()) {
            return null;
        }
        if (newClauses.size() == 1 && promoteSingle) {
            return this.combineBoost(oldQuery, (SpanQuery)newClauses.get(0));
        }
        SpanQuery[] newArray = newClauses.toArray(new SpanQuery[newClauses.size()]);
        SpanQuery newQuery = joiner.join(newArray);
        return this.copyBoost(oldQuery, newQuery);
    }

    public static interface SpanClauseJoiner {
        public SpanQuery join(SpanQuery[] var1);
    }
}

