/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.NearSpans;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanNearQuery
extends SpanQuery {
    private List clauses;
    private int slop;
    private boolean inOrder;
    private String field;

    public SpanNearQuery(SpanQuery[] clauses, int slop, boolean inOrder) {
        this.clauses = new ArrayList(clauses.length);
        int i = 0;
        while (i < clauses.length) {
            SpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
            ++i;
        }
        this.slop = slop;
        this.inOrder = inOrder;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public void setSlop(int slop) {
        this.slop = slop;
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        for (SpanQuery clause : this.clauses) {
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    public Query[] getSubQueries() {
        return this.clauses.toArray(new Query[this.clauses.size()]);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ArrayList<SpanQuery> newClauses = new ArrayList<SpanQuery>(this.clauses.size());
        boolean anyChanged = false;
        for (SpanQuery clause : this.clauses) {
            SpanQuery rewrittenClause = (SpanQuery)clause.rewrite(reader);
            newClauses.add(rewrittenClause);
            if (clause == rewrittenClause) continue;
            anyChanged = true;
        }
        if (!anyChanged) {
            return this;
        }
        SpanNearQuery clone = (SpanNearQuery)this.clone();
        clone.clauses = newClauses;
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanNear([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        return buffer.toString();
    }

    public Spans getSpans(IndexReader reader, Searcher searcher) throws IOException {
        if (this.clauses.size() == 0) {
            return new SpanOrQuery(this.getClauses()).getSpans(reader, searcher);
        }
        if (this.clauses.size() == 1) {
            return ((SpanQuery)this.clauses.get(0)).getSpans(reader, searcher);
        }
        return new NearSpans(this, reader, searcher);
    }
}

