/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.spelt.MinimalAnalyzer;
import org.apache.lucene.spelt.SpellWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.ProgressTracker;

public class LuceneIndexToDict {
    public static void createDict(Directory indexDir, File dictDir) throws IOException {
        LuceneIndexToDict.createDict(indexDir, dictDir, null);
    }

    public static void createDict(Directory indexDir, File dictDir, ProgressTracker prog) throws IOException {
        SpellWriter spellWriter = SpellWriter.open(dictDir);
        spellWriter.clearDictionary();
        spellWriter.setStopwords(StopFilter.makeStopSet(StopAnalyzer.ENGLISH_STOP_WORDS));
        IndexReader indexReader = IndexReader.open(indexDir);
        LuceneIndexToDict.createDict(indexReader, new MinimalAnalyzer(), spellWriter, prog);
        spellWriter.close();
    }

    public static void createDict(IndexReader indexReader, Analyzer analyzer, SpellWriter spellWriter, ProgressTracker prog) throws IOException {
        if (prog == null) {
            prog = new ProgressTracker(){

                public void report(int pctDone, String descrip) {
                }
            };
        }
        ProgressTracker[] phaseTrackers = prog.split(70L, 30L);
        LuceneIndexToDict.queueWords(indexReader, analyzer, spellWriter, phaseTrackers[0]);
        indexReader.close();
        spellWriter.flushQueuedWords(phaseTrackers[1]);
    }

    public static void queueWords(IndexReader reader, Analyzer analyzer, SpellWriter writer, ProgressTracker prog) throws IOException {
        int docId = 0;
        while (docId < reader.maxDoc()) {
            Document doc;
            if ((docId & 0xFF) == 0) {
                prog.progress(docId, reader.maxDoc(), "Re-analyzed " + docId + " documents.");
            }
            if (!reader.isDeleted(docId) && (doc = reader.document(docId)) != null) {
                for (Field field : doc.getFields()) {
                    String[] values;
                    if (!field.isTokenized() || (values = doc.getValues(field.name())) == null) continue;
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Token tok;
                        String val = stringArray[n2];
                        TokenStream toks = analyzer.tokenStream(field.name(), new StringReader(val));
                        while ((tok = toks.next()) != null) {
                            writer.queueWord(tok.termText());
                        }
                        writer.queueBreak();
                        ++n2;
                    }
                }
            }
            ++docId;
        }
        prog.progress(100L, 100L, "Re-analyzed " + reader.maxDoc() + " documents.", true);
    }

    public static void main(String[] args) {
        int exitVal;
        block18: {
            if (args.length != 2) {
                System.err.println("Usage: ... LuceneIndexToDict <luceneIndexDir> <targetDictDir>");
                System.exit(1);
            }
            System.out.println("\n*** Lucene to dictionary conversion utility ***\n");
            IndexReader indexReader = null;
            SpellWriter spellWriter = null;
            exitVal = 1;
            try {
                try {
                    File indexDir = new File(args[0]);
                    File dictDir = new File(args[1]);
                    final long startTime = System.currentTimeMillis();
                    ProgressTracker prog = new ProgressTracker(){

                        public void report(int pctDone, String descrip) {
                            System.out.println(String.format("%6.1f sec  [%3d%%]  %s", Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f), pctDone, descrip));
                        }
                    };
                    prog.setMinInterval(3000);
                    LuceneIndexToDict.createDict(FSDirectory.getDirectory(indexDir), dictDir, prog);
                    exitVal = 0;
                }
                catch (IOException e) {
                    System.out.flush();
                    System.err.println("Unexpected exception: " + e);
                    e.printStackTrace(System.err);
                    try {
                        if (indexReader != null) {
                            indexReader.close();
                        }
                        if (spellWriter != null) {
                            spellWriter.close();
                        }
                        break block18;
                    }
                    catch (IOException iOException) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (indexReader != null) {
                        indexReader.close();
                    }
                    if (spellWriter != null) {
                        spellWriter.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (indexReader != null) {
                    indexReader.close();
                }
                if (spellWriter != null) {
                    spellWriter.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.exit(exitVal);
    }
}

