/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.spelt.LuceneIndexToDict;
import org.apache.lucene.spelt.MinimalAnalyzer;
import org.apache.lucene.spelt.SpellReadWriteTest;
import org.apache.lucene.spelt.SpellReader;
import org.apache.lucene.spelt.SpellWriter;
import org.apache.lucene.store.RAMDirectory;

public class LuceneIndexToDictTest
extends SpellReadWriteTest {
    protected void setUp() throws Exception {
        RAMDirectory luceneDir = new RAMDirectory();
        IndexWriter luceneWriter = new IndexWriter(luceneDir, (Analyzer)new StandardAnalyzer());
        this.addParagraphDocs(luceneWriter);
        luceneWriter.close();
        this.createDictDir("LuceneIndexToDictTest");
        SpellWriter spellWriter = SpellWriter.open(this.dictDir);
        spellWriter.setStopwords(STOP_SET);
        spellWriter.setMinWordFreq(1);
        try {
            IndexReader luceneReader = IndexReader.open(luceneDir);
            LuceneIndexToDict.createDict(luceneReader, new MinimalAnalyzer(), spellWriter, null);
            this.reader = SpellReader.open(this.dictDir);
            this.reader.setStopwords(STOP_SET);
        }
        finally {
            spellWriter.close();
        }
    }

    protected void addParagraphDocs(IndexWriter luceneWriter) throws IOException {
        String[] paras = "The Call of the Wild\nby Jack London\n\nBuck did not read the newspapers, or he would have known that trouble was brewing, not alone for himself, but for every tidewater dog, strong of muscle and with warm, long hair, from Puget Sound to San Diego.  Because men, groping in the Arctic darkness, had found a yellow metal, and because steamship and transportation companies were booming the find, thousands of men were rushing into the Northland.  These men wanted dogs, and the dogs they wanted were heavy dogs, with strong muscles by which to toil, and furry coats to protect them from the frost.\n\nBuck lived at a big house in the sun-kissed Santa Clara Valley. Judge Miller's place, it was called.  It stood back from the road, half hidden among the trees, through which glimpses could be caught of the wide cool veranda that ran around its four sides. The house was approached by gravelled driveways which wound about through wide-spreading lawns and under the interlacing boughs of tall poplars.  At the rear things were on even a more spacious scale than at the front.  There were great stables, where a dozen grooms and boys held forth, rows of vine-clad servants' cottages, an endless and orderly array of outhouses, long grape arbors, green pastures, orchards, and berry patches.  Then there was the pumping plant for the artesian well, and the big cement tank where Judge Miller's boys took their morning plunge and kept cool in the hot afternoon.\n\nAnd over this great demesne Buck ruled.  Here he was born, and here he had lived the four years of his life.  It was true, there were other dogs, There could not but be other dogs on so vast a place, but they did not count.  They came and went, resided in the populous kennels, or lived obscurely in the recesses of the house after the fashion of Toots, the Japanese pug, or Ysabel, the Mexican hairless,--strange creatures that rarely put nose out of doors or set foot to ground. On the other hand, there were the fox terriers, a score of them at least, who yelped fearful promises at Toots and Ysabel looking out of the windows at them and protected by a legion of housemaids armed with brooms and mops.\n\nBut Buck was neither house-dog nor kennel-dog.  The whole realm was his.  He plunged into the swimming tank or went hunting with the Judge's sons; he escorted Mollie and Alice, the Judge's daughters, on long twilight or early morning rambles; on wintry nights he lay at the Judge's feet before the roaring library fire; he carried the Judge's grandsons on his back, or rolled them in the grass, and guarded their footsteps through wild adventures down to the fountain in the stable yard, and even beyond, where the paddocks were, and the berry patches.  Among the terriers he stalked imperiously, and Toots and Ysabel he utterly ignored, for he was king,--king over all creeping, crawling, flying things of Judge Miller's place, humans included.\n\nHis father, Elmo, a huge St.  Bernard, had been the Judge's inseparable companion, and Buck bid fair to follow in the way of his father.  He was not so large,--he weighed only one hundred and forty pounds,--for his mother, Shep, had been a Scotch shepherd dog.  Nevertheless, one hundred and forty pounds, to which was added the dignity that comes of good living and universal respect, enabled him to carry himself in right royal fashion.  During the four years since his puppyhood he had lived the life of a sated aristocrat; he had a fine pride in himself, was even a trifle egotistical, as country gentlemen sometimes become because of their insular situation.  But he had saved himself by not becoming a mere pampered house-dog.  Hunting and kindred outdoor delights had kept down the fat and hardened his muscles; and to him, as to the cold-tubbing races, the love of water had been a tonic and a health preserver.\n\nAnd this was the manner of dog Buck was in the fall of 1897, when the Klondike strike dragged men from all the world into the frozen North.  But Buck did not read the newspapers, and he did not know that Manuel, one of the gardener's helpers, was an undesirable acquaintance.  Manuel had one besetting sin.  He loved to play Chinese lottery.  Also, in his gambling, he had one besetting weakness--faith in a system; and this made his damnation certain. For to play a system requires money, while the wages of a gardener's helper do not lap over the needs of a wife and numerous progeny.\n".split("\n\n");
        paras[0] = String.valueOf(paras[0]) + " europ\u00e4ische europ\u00e4ische europ\u00e4ische";
        Document doc = new Document();
        int i = 0;
        while (i < paras.length) {
            int nFields = doc.getFields().size();
            doc.add(new Field("field" + nFields, paras[i], Field.Store.YES, Field.Index.TOKENIZED));
            if (nFields + 1 == 3) {
                luceneWriter.addDocument(doc);
                doc = new Document();
            }
            ++i;
        }
        if (doc.getFields().size() > 0) {
            luceneWriter.addDocument(doc);
        }
    }
}

